import { Store } from '.';
import { GlobalStyleProps, GlobalStyleRecord } from '../types';
import type { CssRule } from 'grapesjs';
import { DataSourceBuiltIn } from '../plugins/utils/utilsShared';
export declare class GlobalStylesStore {
    dataSourceKeyid: DataSourceBuiltIn;
    records: GlobalStyleRecord[];
    openCategories: Map<string, boolean>;
    store: Store;
    constructor(store: Store);
    get sdkOptionStyles(): GlobalStyleProps[];
    get editor(): import("grapesjs").Editor | undefined;
    get DataSources(): import("grapesjs").DataSourceManager | undefined;
    get recordsByCategory(): import("../types").ItemsByCategory<GlobalStyleRecord>[];
    setCategoryOpen(categoryId: string, open: boolean): void;
    getDataSource(): import("grapesjs").DataSource<import("grapesjs").DataRecordProps> | undefined;
    getRuleByGroup(group: string): CssRule | undefined;
    addStyleRule(record: GlobalStyleRecord): void;
    createDataSource(): import("grapesjs").DataSource<never>;
    onLoad(): void;
}
export declare const useGlobalStylesStore: () => GlobalStylesStore;
