import type { Component, LiteralUnion, ToolbarButtonProps, Trait, TraitProperties } from 'grapesjs';
import { WithEditorProps } from './common';
import { MenuListItem, MenuListItemActionProps } from '../components/MenuList';
export interface ContextMenuItem extends Omit<MenuListItem, 'classNameLabel'> {
    onClick?: (props: MenuListItemActionProps & WithEditorProps) => void;
}
export interface ToolbarItem extends ToolbarButtonProps {
}
export declare enum ComponentContextMenuSource {
    canvas = "canvas",
    layers = "layers"
}
export declare enum ComponentContextMenuItem {
    selectParent = "selectParent",
    duplicate = "duplicate",
    delete = "delete",
    symbolCreate = "symbolCreate",
    symbolDetach = "symbolDetach",
    symbolOverride = "symbolOverride",
    symbolOverrideClear = "symbolOverrideClear"
}
export interface ComponentContextMenuProps extends WithEditorProps {
    items: ContextMenuItem[];
    component: Component;
    type: string;
    source: LiteralUnion<ComponentContextMenuSource, string>;
    event?: Event;
}
export interface ComponentToolbarProps extends WithEditorProps {
    items: ToolbarItem[];
    component: Component;
}
export type ContextMenuItemResult = ContextMenuItem | false | undefined | null;
export type ToolbarItemResult = ToolbarItem | false | undefined | null;
export type ContextMenuFn = (props: ComponentContextMenuProps) => ContextMenuItemResult[] | Promise<ContextMenuItemResult[]>;
export type ToolbarFn = (props: ComponentToolbarProps) => ToolbarItemResult[] | Promise<ToolbarItemResult[]>;
export interface StudioTraitProperties extends TraitProperties {
    tip?: string;
    labelToTitle?: boolean;
    subTraits?: Record<string, StudioTraitProperties[]>;
    visible?: (props: {
        component: Component;
        trait: Trait;
    }) => boolean;
}
export interface ComponentsConfig {
    /**
     * Extend the component context menu.
     * @example
     * contextMenu: ({ items, editor, component, type }) => {
     *  return [
     *    ...items,
     *    {
     *      id: 'customGlobalAction',
     *      label: 'Custom Global Action',
     *      onClick: () => alert('Component HTML: ' + component.toHTML()),
     *    },
     *    type === 'image' && { id: 'customImageAction', label: 'Only for images' },
     *  ]
     * }
     */
    contextMenu?: ContextMenuFn;
    /**
     * Extend the component toolbar menu.
     * @example
     * toolbar: ({ items, editor, component, type }) => {
     *  return [
     *    ...items,
     *    {
     *      id: 'customGlobalAction',
     *      label: 'Custom Global Action',
     *      command: () => alert('Component HTML: ' + component.toHTML()),
     *    }
     *  ]
     * }
     */
    toolbar?: ToolbarFn;
}
