import type { Component, ComponentDataCollection, ComponentDataCondition, ComponentDataVariable, ExpressionProps, LogicGroupProps, ObjectAny } from 'grapesjs';
import { DataConditionResolverProps } from '../components/public/StudioDataConditionPicker';
import { DataCollectionResolverProps } from '../components/public/types/StudioDataCollectionPickerSchema';
import { DataVariableResolverProps } from '../components/public/types/StudioDataVariablePickerSchema';
export type { DataCollectionResolverProps } from '../components/public/types/StudioDataCollectionPickerSchema';
export type { DataVariableResolverProps } from '../components/public/types/StudioDataVariablePickerSchema';
export type GetCustomPath = (opts: {
    component: Component;
    path: string;
    paths: string[];
}) => string;
export interface ExportConfig {
    getCustomPath?: GetCustomPath;
}
export interface DataSourcesConfig {
    /**
     * Configuration for global datasets that can be used as data sources.
     */
    globalData?: GlobalDataset;
    /**
     * Add data source components to blocks.
     * @default false
     */
    blocks?: boolean;
    /**
     * Configuration options for exporting data resolvers.
     */
    exportConfig?: ExportConfig;
}
/**
 * Represents the global datasets available as data sources.
 * For example:
 * ```
 * {
 * user: { firstname: 'John', lastname: 'Doe', age: 30 },
 * products: [{ name: 'Laptop', price: 1200 }, { name: 'Mouse', price: 25 }]
 * }
 * ```
 * Each key in this record represents the name of a global dataset (e.g., 'user', 'products').
 * The value associated with each key can be either a single object or an array of objects, representing the data for that dataset.
 */
export type GlobalDataset = Record<string, ObjectAny | ObjectAny[]>;
export type ConditionType = ExpressionProps | LogicGroupProps;
export interface IDataSourceExporter {
    getHelperId?(operator: string, typeHint?: 'string' | 'number' | 'any'): string | undefined;
    getVariableSyntax(options: {
        component: ComponentDataVariable;
        dataResolver: DataVariableResolverProps;
    }): string;
    getCollectionStartSyntax(options: {
        component: ComponentDataCollection;
        dataResolver: DataCollectionResolverProps;
    }): string;
    getCollectionEndSyntax(options: {
        component: ComponentDataCollection;
    }): string;
    getConditionalStartSyntax(options: {
        component: ComponentDataCondition;
        dataResolver: DataConditionResolverProps;
    }): string;
    getConditionElseSyntax(options: {
        component: ComponentDataCondition;
    }): string;
    getConditionalEndSyntax(options: {
        component: ComponentDataCondition;
    }): string;
}
export interface IDataSourceImporter {
    import(template: string): string;
}
export type ExpressionSideType = string | number | DataVariableResolverProps;
export declare enum DataComponentTypes {
    variable = "data-variable",
    condition = "data-condition",
    conditionTrue = "data-condition-true-content",
    conditionFalse = "data-condition-false-content",
    collection = "data-collection",
    collectionItem = "data-collection-item"
}
