import type { DeviceProperties } from 'grapesjs';
export interface DevicesConfig {
    /**
     * Provide an array of devices.
     * @example
     * default: [
     *  {
     *   id: 'desktop',
     *   name: 'Desktop',
     *   width: ''
     *  },
     *  {
     *    id: 'tablet',
     *    name: 'Tablet',
     *    width: '770px',
     *    widthMedia: '992px',
     *  }
     * ]
     */
    default?: DeviceProperties[];
    /**
     * The device `id` to select on start, if not indicated, the first available from `devices` will be used.
     * @default ''
     * @example
     * selected: 'tablet'
     */
    selected?: string;
}
