export interface BaseFontFaceArgs {
    /**
     * The url with the font file for this variant.
     */
    source: string;
    /**
     * Extra arguments for FontFace init.
     *
     * https://developer.mozilla.org/en-US/docs/Web/API/FontFace/FontFace#descriptors
     *
     * @examples
     * // variable fonts
     * descriptors: {
     *   // here we describe the range of values supported by the weight axis of this variable font
     *   weight: "300 800",
     * }
     */
    descriptors?: object;
}
export interface BaseFont {
    /**
     * The font variants that will be available in the editor when you add this font.
     *
     * @examples
     * variants: {
     *   regular: {
     *     source: 'https://fonts.gstatic.com/s/aboreto/v2/5DCXAKLhwDDQ4N8blKHeA2yuxSY.woff2',
     *   }
     * }
     */
    variants: Record<string, BaseFontFaceArgs>;
}
