import { StudioLayoutInputFieldConfigProps } from '../types';
import { CategoryBaseProps } from './common';
export declare enum GlobalStyleFieldType {
    text = "text",
    number = "number",
    color = "color",
    selectFont = "selectFont",
    select = "select",
    radio = "radio"
}
export interface GlobalStyleFieldTextProps extends Omit<StudioLayoutInputFieldConfigProps, 'type' | 'onInput' | 'onChange' | 'value'> {
    /**
     * Simple text field type.
     */
    type: `${GlobalStyleFieldType.text}`;
    /**
     * Default value to use on the field.
     * Unlike the `defaultValue` of the global style property, this won't affect the global style itself and will only serve as a placeholder.
     */
    defaultValue?: string;
}
export interface GlobalStyleFieldColorProps extends Omit<GlobalStyleFieldTextProps, 'type'> {
    /**
     * Field type for colors properties.
     */
    type: `${GlobalStyleFieldType.color}`;
}
export interface GlobalStyleFieldNumberProps extends Omit<GlobalStyleFieldTextProps, 'type'> {
    /**
     * Field type for numeric properties.
     */
    type: `${GlobalStyleFieldType.number}`;
    /**
     * Minimum value allowed.
     */
    min?: number;
    /**
     * Maximum value allowed.
     */
    max?: number;
    /**
     * Step value.
     */
    step?: number;
    /**
     * Units to display.
     * @example
     * ['px', 'rem']
     */
    units?: string[];
}
export interface GlobalStyleFieldSelectProps extends Omit<GlobalStyleFieldTextProps, 'type'> {
    /**
     * Select field type.
     */
    type: `${GlobalStyleFieldType.select}`;
    /**
     * Options to display in the field.
     * @example
     * [{ id: 'option1', label: 'Option 2' }]
     */
    options?: (GlobalStyleFieldSelectOption | string)[];
}
export interface GlobalStyleFieldSelectFontProps extends Omit<GlobalStyleFieldTextProps, 'type'> {
    /**
     * Select field type.
     */
    type: `${GlobalStyleFieldType.selectFont}`;
    /**
     * Prepend custom options to the font select.
     * @example
     * [{ id: 'option0', label: 'Option 0' }]
     */
    options?: (GlobalStyleFieldSelectOption | string)[];
}
export interface GlobalStyleFieldRadioProps extends Omit<GlobalStyleFieldTextProps, 'type'> {
    /**
     * Similar to the select field type but render options as buttons.
     */
    type: `${GlobalStyleFieldType.radio}`;
    /**
     * Options to display in the field.
     * @example
     * [{ id: 'option1', label: 'Option 2' }]
     */
    options?: (GlobalStyleFieldRadioOption | string)[];
}
export interface GlobalStyleFieldSelectOption {
    id: string;
    label?: string;
}
export interface GlobalStyleFieldRadioOption extends GlobalStyleFieldSelectOption {
    icon?: string;
    title?: string;
}
export type GlobalStyleFieldProps = GlobalStyleFieldTextProps | GlobalStyleFieldColorProps | GlobalStyleFieldNumberProps | GlobalStyleFieldSelectProps | GlobalStyleFieldSelectFontProps | GlobalStyleFieldRadioProps;
export interface GlobalStyleProps {
    /**
     * A unique identifier for the style rule.
     * @example
     * 'myRuleId'
     */
    id: string;
    /**
     * The CSS property name (e.g., 'color', 'font-size', 'margin', etc.).
     * @example
     * 'font-size'
     */
    property: string;
    /**
     * The CSS selector to which this style will be applied.
     * @example
     * 'h1'
     */
    selector: string;
    /**
     * The label for the style rule (used in the editor UI).
     * @example
     * 'H1 size'
     */
    label?: string;
    /**
     * The field to render in the editor UI.
     */
    field?: GlobalStyleFieldType | `${GlobalStyleFieldType}` | GlobalStyleFieldProps;
    /**
     * Default value to use on the CSS property.
     */
    defaultValue?: string | number;
    /**
     * The value to be applied to the CSS property.
     */
    value?: string | number;
    /**
     * Put the style rule in a category.
     * @example
     * { id: 'h1Styles', label: 'H1 Styles' }
     */
    category?: CategoryBaseProps;
}
