import type { Component, ComponentView, Editor } from 'grapesjs';
import { BaseFont, BaseFontFaceArgs } from './fontsSchema';
export declare enum ThemeValue {
    dark = "dark",
    light = "light",
    auto = "auto"
}
export interface RteCustomToolbarProps {
    editor: Editor;
    component: Component;
    view: ComponentView;
    el: HTMLElement;
}
export interface InternalFontFaceArgs {
    family: string;
    variant: string;
    source: string;
    descriptors?: FontFaceDescriptors;
}
export type MenuVariantFontFaceArgs = InternalFontFaceArgs & {
    family: `menuFont-${string}` | `"menuFont-${string}"`;
};
export interface InternalFont {
    family: string;
    familyLabel: string;
    menuVariant?: MenuVariantFontFaceArgs;
    variants: Record<string, InternalFontFaceArgs>;
}
/**
 * Arguments to call the FontFace constructor of the FontFace web API.
 * https://developer.mozilla.org/en-US/docs/Web/API/FontFace/FontFace
 */
export interface FontFaceArgs extends BaseFontFaceArgs {
    descriptors?: InternalFontFaceArgs['descriptors'];
}
export interface Font extends BaseFont {
    /**
     * Variant used only for display in font lists.
     * The font file it points to should contain only the specific letters of the font family name.
     * If not set, the first variant is used by default (for...in traversal order).
     */
    menuVariant?: FontFaceArgs;
    variants: Record<string, FontFaceArgs>;
}
export type FontWithFamily = Font & {
    family: string;
};
