import { H as History, P as Permissions, C as ComponentData, a as Config, U as UserGenerics, F as Fields, b as PuckAction, R as RootDataWithProps, c as ResolveDataTrigger, d as Plugin, O as Overrides, V as Viewports, I as IframeConfig, e as UiState, f as ComponentConfig, A as AppState, M as Metadata, g as Field, h as FieldProps, D as DropZoneProps, i as Data, j as OnAction, k as InitialHistory, l as ItemSelector } from './walk-tree-DrJNb8b-.mjs';
export { _ as Adaptor, Y as ArrayField, t as ArrayState, ab as AsFieldProps, B as BaseData, K as BaseField, G as ComponentDataMap, z as ComponentDataOptionalId, J as Content, a2 as CustomField, a1 as CustomFieldRender, a8 as DefaultComponentProps, a5 as DefaultRootFieldProps, a7 as DefaultRootProps, a6 as DefaultRootRenderProps, m as Direction, n as DragAxis, a0 as ExternalField, $ as ExternalFieldWithAdaptor, ad as ExtractPropsFromConfig, ae as ExtractRootPropsFromConfig, r as FieldRenderFunctions, s as ItemWithId, E as MappedItem, N as NumberField, Z as ObjectField, q as OverrideKey, u as PuckComponent, a4 as PuckContext, X as RadioField, v as RootConfig, y as RootData, x as RootDataWithoutProps, Q as SelectField, S as Slot, a3 as SlotField, T as TextField, L as TextareaField, o as Viewport, ac as WithChildren, a9 as WithId, aa as WithPuckProps, W as WithSlotProps, af as migrate, p as overrideKeys, ah as resolveAllData, ag as transformProps, w as walkTree } from './walk-tree-DrJNb8b-.mjs';
import * as react_jsx_runtime from 'react/jsx-runtime';
import * as react from 'react';
import react__default, { ReactNode, SyntheticEvent, ReactElement } from 'react';

type HistorySlice<D = any> = {
    index: number;
    hasPast: () => boolean;
    hasFuture: () => boolean;
    histories: History<D>[];
    record: (data: D) => void;
    back: VoidFunction;
    forward: VoidFunction;
    currentHistory: () => History;
    nextHistory: () => History<D> | null;
    prevHistory: () => History<D> | null;
    setHistories: (histories: History[]) => void;
    setHistoryIndex: (index: number) => void;
    initialAppState: D;
};

type NodeMethods = {
    sync: () => void;
    hideOverlay: () => void;
    showOverlay: () => void;
};
type PuckNodeInstance = {
    id: string;
    methods: NodeMethods;
    element: HTMLElement | null;
};
type NodesSlice = {
    nodes: Record<string, PuckNodeInstance | undefined>;
    registerNode: (id: string, node: Partial<PuckNodeInstance>) => void;
    unregisterNode: (id: string, node?: Partial<PuckNodeInstance>) => void;
};

type PermissionsArgs<UserConfig extends Config = Config, G extends UserGenerics<UserConfig> = UserGenerics<UserConfig>> = {
    item?: G["UserComponentData"] | null;
    type?: keyof G["UserProps"];
    root?: boolean;
};
type GetPermissions<UserConfig extends Config = Config> = (params?: PermissionsArgs<UserConfig>) => Permissions;
type ResolvePermissions<UserConfig extends Config = Config> = (params?: PermissionsArgs<UserConfig>, force?: boolean) => void;
type RefreshPermissions<UserConfig extends Config = Config> = (params?: PermissionsArgs<UserConfig>, force?: boolean) => void;
type Cache = Record<string, {
    lastPermissions: Partial<Permissions>;
    lastData: ComponentData | null;
}>;
type PermissionsSlice = {
    cache: Cache;
    globalPermissions: Permissions;
    resolvedPermissions: Record<string, Partial<Permissions> | undefined>;
    getPermissions: GetPermissions<Config>;
    resolvePermissions: ResolvePermissions<Config>;
    refreshPermissions: RefreshPermissions<Config>;
};

type ComponentOrRootData = Omit<ComponentData<any>, "type">;
type FieldsSlice = {
    fields: Fields | Partial<Fields>;
    loading: boolean;
    lastResolvedData: Partial<ComponentOrRootData>;
    id: string | undefined;
};

type Status = "LOADING" | "MOUNTED" | "READY";
type ZoomConfig = {
    autoZoom: number;
    rootHeight: number;
    zoom: number;
};
type ComponentState = Record<string, {
    loadingCount: number;
}>;
type AppStore<UserConfig extends Config = Config, G extends UserGenerics<UserConfig> = UserGenerics<UserConfig>> = {
    state: G["UserAppState"];
    dispatch: (action: PuckAction) => void;
    config: UserConfig;
    componentState: ComponentState;
    setComponentState: (componentState: ComponentState) => void;
    setComponentLoading: (id: string, loading?: boolean, defer?: number) => () => void;
    unsetComponentLoading: (id: string) => void;
    pendingLoadTimeouts: Record<string, NodeJS.Timeout>;
    resolveComponentData: <T extends ComponentData | RootDataWithProps>(componentData: T, trigger: ResolveDataTrigger) => Promise<{
        node: T;
        didChange: boolean;
    }>;
    resolveAndCommitData: () => void;
    plugins: Plugin[];
    overrides: Partial<Overrides>;
    viewports: Viewports;
    zoomConfig: ZoomConfig;
    setZoomConfig: (zoomConfig: ZoomConfig) => void;
    status: Status;
    setStatus: (status: Status) => void;
    iframe: IframeConfig;
    selectedItem?: G["UserData"]["content"][0] | null;
    setUi: (ui: Partial<UiState>, recordHistory?: boolean) => void;
    getComponentConfig: (type?: string) => ComponentConfig | null | undefined;
    onAction?: (action: PuckAction, newState: AppState, state: AppState) => void;
    metadata: Metadata;
    fields: FieldsSlice;
    history: HistorySlice;
    nodes: NodesSlice;
    permissions: PermissionsSlice;
};

declare const ActionBar: {
    ({ label, children, }: {
        label?: string;
        children?: ReactNode;
    }): react_jsx_runtime.JSX.Element;
    Action: ({ children, label, onClick, }: {
        children: ReactNode;
        label?: string;
        onClick: (e: SyntheticEvent) => void;
    }) => react_jsx_runtime.JSX.Element;
    Label: ({ label }: {
        label: string;
    }) => react_jsx_runtime.JSX.Element;
    Group: ({ children }: {
        children: ReactNode;
    }) => react_jsx_runtime.JSX.Element;
};
declare const Action: ({ children, label, onClick, }: {
    children: ReactNode;
    label?: string;
    onClick: (e: SyntheticEvent) => void;
}) => react_jsx_runtime.JSX.Element;
declare const Group: ({ children }: {
    children: ReactNode;
}) => react_jsx_runtime.JSX.Element;
declare const Label: ({ label }: {
    label: string;
}) => react_jsx_runtime.JSX.Element;

declare const FieldLabel: ({ children, icon, label, el, readOnly, className, }: {
    children?: ReactNode;
    icon?: ReactNode;
    label: string;
    el?: "label" | "div";
    readOnly?: boolean;
    className?: string;
}) => react_jsx_runtime.JSX.Element;
type FieldNoLabel<Props extends any = any> = Omit<Field<Props>, "label">;
declare function AutoField<ValueType = any, FieldType extends FieldNoLabel<ValueType> = FieldNoLabel<ValueType>>(props: FieldProps<FieldType, ValueType>): react_jsx_runtime.JSX.Element | null;

declare const Button: ({ children, href, onClick, variant, type, disabled, tabIndex, newTab, fullWidth, icon, size, loading: loadingProp, ...props }: {
    children: ReactNode;
    href?: string;
    onClick?: (e: any) => void | Promise<void>;
    variant?: "primary" | "secondary";
    type?: "button" | "submit" | "reset";
    disabled?: boolean;
    tabIndex?: number;
    newTab?: boolean;
    fullWidth?: boolean;
    icon?: ReactNode;
    size?: "medium" | "large";
    loading?: boolean;
}) => react_jsx_runtime.JSX.Element;

declare const Drawer: {
    ({ children, droppableId, direction, }: {
        children: ReactNode;
        droppableId?: string;
        direction?: "vertical" | "horizontal";
    }): react_jsx_runtime.JSX.Element;
    Item: ({ name, children, id, label, index, isDragDisabled, }: {
        name: string;
        children?: (props: {
            children: ReactNode;
            name: string;
        }) => ReactElement;
        id?: string;
        label?: string;
        index?: number;
        isDragDisabled?: boolean;
    }) => react_jsx_runtime.JSX.Element;
};

declare const DropZone: react.ForwardRefExoticComponent<DropZoneProps & react.RefAttributes<HTMLDivElement>>;

declare const IconButton: ({ children, href, onClick, variant, type, disabled, tabIndex, newTab, fullWidth, title, }: {
    children: ReactNode;
    href?: string;
    onClick?: (e: SyntheticEvent) => void | Promise<void>;
    variant?: "primary" | "secondary";
    type?: "button" | "submit" | "reset";
    disabled?: boolean;
    tabIndex?: number;
    newTab?: boolean;
    fullWidth?: boolean;
    title: string;
}) => react_jsx_runtime.JSX.Element;

type PuckProps<UserConfig extends Config = Config, G extends UserGenerics<UserConfig> = UserGenerics<UserConfig>> = {
    children?: ReactNode;
    config: UserConfig;
    data: Partial<G["UserData"] | Data>;
    ui?: Partial<UiState>;
    onChange?: (data: G["UserData"]) => void;
    onPublish?: (data: G["UserData"]) => void;
    onAction?: OnAction<G["UserData"]>;
    permissions?: Partial<Permissions>;
    plugins?: Plugin[];
    overrides?: Partial<Overrides>;
    renderHeader?: (props: {
        children: ReactNode;
        dispatch: (action: PuckAction) => void;
        state: G["UserAppState"];
    }) => ReactElement;
    renderHeaderActions?: (props: {
        state: G["UserAppState"];
        dispatch: (action: PuckAction) => void;
    }) => ReactElement;
    headerTitle?: string;
    headerPath?: string;
    viewports?: Viewports;
    iframe?: IframeConfig;
    dnd?: {
        disableAutoScroll?: boolean;
    };
    initialHistory?: InitialHistory;
    metadata?: Metadata;
};
declare function Puck<UserConfig extends Config = Config, G extends UserGenerics<UserConfig> = UserGenerics<UserConfig>>(props: PuckProps<UserConfig>): react_jsx_runtime.JSX.Element;
declare namespace Puck {
    var Components: () => react_jsx_runtime.JSX.Element;
    var Fields: react.MemoExoticComponent<({ wrapFields }: {
        wrapFields?: boolean;
    }) => react_jsx_runtime.JSX.Element>;
    var Outline: () => react_jsx_runtime.JSX.Element;
    var Preview: ({ id }: {
        id?: string;
    }) => react_jsx_runtime.JSX.Element;
}

declare const renderContext: react__default.Context<{
    config: Config;
    data: Data;
    metadata: Metadata;
}>;
declare function Render<UserConfig extends Config = Config, G extends UserGenerics<UserConfig> = UserGenerics<UserConfig>>({ config, data, metadata, }: {
    config: UserConfig;
    data: Partial<G["UserData"] | Data>;
    metadata?: Metadata;
}): react_jsx_runtime.JSX.Element;

type WithGet<T> = T & {
    get: () => T;
};
type UsePuckData<UserConfig extends Config = Config, G extends UserGenerics<UserConfig> = UserGenerics<UserConfig>> = {
    appState: AppState;
    config: UserConfig;
    dispatch: AppStore["dispatch"];
    getPermissions: GetPermissions<UserConfig>;
    refreshPermissions: RefreshPermissions<UserConfig>;
    selectedItem: G["UserComponentData"] | null;
    getItemBySelector: (selector: ItemSelector) => ComponentData | undefined;
    getItemById: (id: string) => ComponentData | undefined;
    getSelectorForId: (id: string) => Required<ItemSelector> | undefined;
    history: {
        back: HistorySlice["back"];
        forward: HistorySlice["forward"];
        setHistories: HistorySlice["setHistories"];
        setHistoryIndex: HistorySlice["setHistoryIndex"];
        histories: HistorySlice["histories"];
        index: HistorySlice["index"];
        hasPast: boolean;
        hasFuture: boolean;
    };
};
type PuckApi<UserConfig extends Config = Config> = UsePuckData<UserConfig>;
type UsePuckStore<UserConfig extends Config = Config> = WithGet<PuckApi<UserConfig>>;
/**
 * createUsePuck
 *
 * Create a typed usePuck hook, which is necessary because the user may provide a generic type but not
 * a selector type, and TS does not currently support partial inference.
 * Related: https://github.com/microsoft/TypeScript/issues/26242
 *
 * @returns a typed usePuck function
 */
declare function createUsePuck<UserConfig extends Config = Config>(): <T = PuckApi<UserConfig>>(selector: (state: UsePuckStore<UserConfig>) => T) => T;
declare function usePuck<UserConfig extends Config = Config>(): UsePuckStore<UserConfig>;
/**
 * Get the latest state without relying on a render
 *
 * @returns PuckApi
 */
declare function useGetPuck(): () => UsePuckStore<Config>;

export { Action, ActionBar, AppState, AutoField, Button, ComponentConfig, ComponentData, Config, Data, Drawer, DropZone, Field, FieldLabel, FieldProps, Fields, Group, History, IconButton, IframeConfig, InitialHistory, Label, Metadata, OnAction, Overrides, Permissions, Plugin, Puck, PuckAction, type PuckApi, Render, ResolveDataTrigger, RootDataWithProps, UiState, type UsePuckData, UserGenerics, Viewports, createUsePuck, renderContext, useGetPuck, usePuck };
