/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * Released under MIT see LICENSE.txt in the project root for license information.
 * Copyright (c) 2013-2025 Valeriy Chupurnov. All rights reserved. https://xdsoft.net
 */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
        r = Reflect.decorate(decorators, target, key, desc);
    else
        for (var i = decorators.length - 1; i >= 0; i--)
            if (d = decorators[i])
                r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { watch } from "../../core/decorators/watch/watch.js";
import { Dom } from "../../core/dom/dom.js";
import { extendLang } from "../../core/global.js";
import { keys } from "../../core/helpers/utils/utils.js";
import { Plugin } from "../../core/plugin/index.js";
import "./config.js";
import { Jodit } from "../../jodit.js";
import { execSpellCommand } from "./helpers/exec-spell-command.js";
import * as langs from "./langs/index.js";
export class SpeechRecognizeNative extends Plugin {
    constructor() {
        super(...arguments);
        this.buttons = [
            {
                group: 'state',
                name: 'speechRecognize'
            }
        ];
        this._commandToWord = {};
    }
    afterInit(jodit) {
        const { commands } = jodit.o.speechRecognize;
        if (commands) {
            extendLang(langs);
            keys(commands, false).forEach(words => {
                const keys = words.split('|');
                keys.forEach(key => {
                    key = key.trim().toLowerCase();
                    this._commandToWord[key] = commands[words];
                    const translatedKeys = jodit.i18n(key);
                    if (translatedKeys !== key) {
                        translatedKeys.split('|').forEach(translatedKey => {
                            this._commandToWord[translatedKey.trim().toLowerCase()] = commands[words].trim();
                        });
                    }
                });
            });
        }
    }
    beforeDestruct(jodit) {
        Dom.safeRemove(this.messagePopup);
    }
    onSpeechRecognizeProgressResult(text) {
        if (!this.messagePopup) {
            this.messagePopup = this.j.create.div('jodit-speech-recognize__popup');
        }
        this.j.workplace.appendChild(this.messagePopup);
        this.j.async.clearTimeout(this.__hidePopupTimeout);
        this.__hidePopupTimeout = this.j.async.setTimeout(() => {
            Dom.safeRemove(this.messagePopup);
        }, 1000);
        this.messagePopup.innerText = text + '|';
    }
    onSpeechRecognizeResult(text) {
        this.j.async.clearTimeout(this.__hidePopupTimeout);
        Dom.safeRemove(this.messagePopup);
        const { j } = this;
        const { s } = j;
        if (!this._checkCommand(text)) {
            const { range } = s, node = s.current();
            if (s.isCollapsed() &&
                Dom.isText(node) &&
                Dom.isOrContains(j.editor, node) &&
                node.nodeValue) {
                const sentence = node.nodeValue;
                node.nodeValue =
                    sentence +
                        (/[\u00A0 ]\uFEFF*$/.test(sentence) ? '' : ' ') +
                        text;
                range.setStartAfter(node);
                s.selectRange(range);
                j.synchronizeValues();
            }
            else {
                s.insertHTML(text);
            }
        }
    }
    _checkCommand(command) {
        command = command.toLowerCase().replace(/\./g, '');
        if (this._commandToWord[command]) {
            execSpellCommand(this.j, this._commandToWord[command]);
            return true;
        }
        return false;
    }
}
__decorate([
    watch(':speechRecognizeProgressResult')
], SpeechRecognizeNative.prototype, "onSpeechRecognizeProgressResult", null);
__decorate([
    watch(':speechRecognizeResult')
], SpeechRecognizeNative.prototype, "onSpeechRecognizeResult", null);
Jodit.plugins.add('speech-recognize', SpeechRecognizeNative);
