import React from 'react'

import Label from './Label'
import { faXmark } from '@fortawesome/free-solid-svg-icons'
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome'


const AdvancedInput = ({ options, selectedOptions, label = 'Test123', className, labelClassName, disabled, DefaultValue, onChange, type = "text", ref, placeholder, inputClassName }) => {
    return (
        <section className={`${className}`}>
            <Label labelClassName={labelClassName}>{label}</Label>
        <div className={` rounded-md px-1 py-2 border border-solid focus:border-2 focus:border-[#21659B] border-gray-900 bg-white`}>
            
            <div className='flex gap-2'>
                    <div className='rounded-md bg-black text-white flex gap-2 items-center justify-center px-2 py-1 text-[10px]'>Test <FontAwesomeIcon className='text-[10px]' icon={faXmark}></FontAwesomeIcon></div>
            <input disabled={disabled} defaultValue={DefaultValue ?? null} onChange={onChange} type={type} ref={ref} placeholder={placeholder} className={`${inputClassName} w-full border-0  `}></input>
            </div>
        </div>
        </section>
    )
}

export default AdvancedInput