import React from 'react'

import { Modal,Box, Typography } from '@mui/material';

const BasicModal = ({ children = null, title = "New Modal", open = false, onBackdropClick }) => {
  return (
      <Modal
          onBackdropClick={onBackdropClick}
          open={open}
          aria-labelledby="modal-modal-title"
          aria-describedby="modal-modal-description"
      >
          <Box sx={{ position: 'absolute', top: '50%', left: '50%', transform: 'translate(-50%, -50%)', width: 400, bgcolor: 'background.paper', border: '2px solid #000', boxShadow: 24, p: 4, }}>
              <Typography id="modal-modal-title" variant="h6" component="h2">
                  {title}
              </Typography>
              {children}
          </Box>
      </Modal>
  )
}

export default BasicModal