import React, { useState } from "react";
import { Puck } from "@measured/puck";
import "@measured/puck/puck.css";

// Define your config
const config = {
    components: {
        HeadingBlock: {
            fields: {
                children: { label: "Heading Text", type: "text" },
            },
            render: ({ children }) => <h1>{children}</h1>,
        },
    },
};

// Provide initial data matching your config
const initialData = {
    content: [], // Puck expects a content array
};

export function BlockEditor() {
    // Store data in state
    const [data, setData] = useState(initialData);

    // Handle publish
    const save = (newData) => {
        console.log("Publish!", newData);
        //Save to your backend here
    };

    return (
        <Puck
            config={config}
            data={data}
            onPublish={save}
            onChange={(newData) => setData(newData)}
        />
    );
}
