import StudioEditor from '@grapesjs/studio-sdk/react';
import { swiperComponent, iconifyComponent, layoutSidebarButtons } from '@grapesjs/studio-sdk-plugins';
import '@grapesjs/studio-sdk/style';

import React from 'react';
import Button from './Button';
import { router } from '@inertiajs/react';
import axios from 'axios';


export default function BlockEditorGrape({ page,csrf_token,grape_key,onSubmit = ()=>{}}) {

    const projectJSONFromServer = {
        pages: [
            {
                name: 'Home', component: `${page?.component ?? ''} ${page?.styles ? `<style>${page?.styles}</style>` : ''}`
            },
        ]
    };

    const handleSubmit = async  ({ project, editor })  => {
        // Here you have the editor instance:
        if (editor) {
            const fullHtml = editor.getHtml();

            const parser = new DOMParser();
            const doc = parser.parseFromString(fullHtml, 'text/html');
            const innerBody = doc.body.innerHTML;

            

            onSubmit({
                ...page,
                component: innerBody,
                styles: editor.getCss()
            });
            // Now you can send this to your backend
        }

        
    }
 
    return (
        <StudioEditor
            options={{
               // licenseKey: import.meta.env.VITE_GRAPESJS_LICENSE_KEY,
                licenseKey: `${grape_key}`,
                pages: {
                    add: false,
                },
                plugins: [
                    editor => {
                        const { Blocks } = editor;
                        const blockMedia = '<svg viewBox="0 0 24 24"><path d="M19,5H22V7H19V10H17V7H14V5H17V2H19V5M17,19V13H19V21H3V5H11V7H5V19H17Z" /></svg>';

                        Blocks.add('Contact Form', {
                            label: 'Contact Form',
                            media: blockMedia,
                            category: { id: 'custom-forms', label: 'Custom Forms' },
                            content: '<section class="contact-section"> <div class="contact-intro"> <h2 class="contact-title">Get in Touch</h2> <p class="contact-description"> Fill out the form below and well get back to you as soon as possible. </p> </div > <form class="contact-form" action="/api/contact-us" method="POST"> <input type="hidden" name="access_key" value="YOUR_ACCESS_KEY_HERE" /> <input type="hidden" name="subject" value="New Contact Form Submission from Web3Forms" /> <input type="hidden" name="from_name" value="My Website" /> <div class="form-group-container"> <div class="form-group"> <label for="name" class="form-label">Name</label> <input id="name" name="name" class="form-input" placeholder="Your name" type="text" required /> </div> <div class="form-group"> <label for="email" class="form-label">Email</label> <input id="email" name="email" class="form-input" placeholder="Your email" type="email" required /> </div> <div class="form-group"> <label for="phone" class="form-label">Phone</label> <input id="phone" name="phone" class="form-input" placeholder="+1 (234) 56789" type="text" /> </div> <div class="form-group"> <label for="message" class="form-label">Message</label> <textarea id="message" name="message" class="form-textarea" placeholder="Your message" required></textarea> </div> </div> <button class="form-submit" type="submit">Send Message</button> </form> </section ><style> .contact-section { width: 100%; max-width: 40rem; margin-left: auto; margin-right: auto; padding: 3rem 1rem; } .contact-intro > * + * { margin-top: 1rem; } .contact-title { font-size: 1.875rem; line-height: 2.25rem; font-weight: 700; } .contact-description { color: rgb(107 114 128); } .form-group-container { display: grid; gap: 1rem; margin-top: 2rem; } .form-group { display: flex; flex-direction: column; } .form-label { margin-bottom: 0.5rem; } .form-input, .form-textarea { padding: 0.5rem; border: 1px solid #e5e7eb; height: 2.5rem; width: 100%; border-radius: 0.375rem; font-size: 0.875rem; line-height: 1.25rem; } .form-textarea { min-height: 120px; resize: vertical; } .form-input::placeholder, .form-textarea::placeholder { color: #6b7280; } .form-input:focus-visible, .form-textarea:focus-visible { outline: 2px solid #2563eb; outline-offset: 2px; } .form-submit { width: 100%; margin-top: 1.2rem; background-color: #3124ca; color: #fff; padding: 13px 5px; border-radius: 0.375rem; font-size: 1rem; cursor: pointer; border: none; transition: background-color 0.3s ease; } .form-submit:hover { background-color: #1f1aa5; } </style>'
                        });

                    },
                    layoutSidebarButtons,
                    swiperComponent.init({ /* Plugin options: https://app.grapesjs.com/docs-sdk/plugins/components/swiper */ }),
                    iconifyComponent.init({ /* Plugin options: https://app.grapesjs.com/docs-sdk/plugins/components/iconify */ })
                ],
                theme: 'dark',
                project: {
                    type: 'web',
                    // TODO: replace with a unique id for your projects. e.g. an uuid
                    id: 'UNIQUE_PROJECT_ID'
                },
                
                identity: {
                    // TODO: replace with a unique id for your end users. e.g. an uuid
                    id: 'UNIQUE_END_USER_ID'
                },
                assets: {
                    storageType: 'self',
                    // Provide a custom upload handler for assets
                    onUpload: async ({ files }) => {
                        const body = new FormData();
                        const filesArray = Array.isArray(files) ? files : [...files]; // Ensure files is an array

                        filesArray.forEach((file) => {
                            body.append('files[]', file); // Laravel expects files[]
                        });
                  

                        
                        const response = await axios.post('/admin/assets', body, {
                            headers: {
                                'Accept': 'application/json',
                            },
                        });

                       
                        const result = response.data;
                        // The expected result should be an array of assets, eg.
                        // [{ src: 'ASSET_URL' }]
              
                        return result.files;
                    },
                },
                storage: {
                    type: 'self', project: projectJSONFromServer, autosaveChanges:99999999999999,         // <- Disable autosave trigger by number of changes
                    autosaveIntervalMs: 99999999999999999, 
                    // Provide a custom handler for saving the project data.
                    onSave: handleSubmit,
                    // Provide a custom handler for loading project data.
                    onLoad: async () => {
                        /*throw new Error('Implement your "onLoad"!');
                        const response = await fetch('PROJECT_LOAD_URL');
                        const project = await response.json();
                        // The project JSON is expected to be returned inside an object.
                        return { project };*/
                    },
                }
            }}
        />
    );
}