import { faClose } from '@fortawesome/free-solid-svg-icons'
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome'
import React from 'react'

import Label from './Label'

const FileInput = ({ isPreview = false, image, disabled = false, className = '', labelClassName = 'ml-2', setState = null, children, onChange = (e) => { setState((e.target.files[0])) } }) => {

    return (
        <div className={className}>
            {children ? <Label labelClassName={labelClassName}>{...children}
                {image && isPreview ? <FontAwesomeIcon onClick={() => {
                    if (disabled) {
                        return
                    }
                    setState(null)
                }} className='text-red-500 ml-2 cursor-pointer' icon={faClose} /> : ''}
            </Label> : ''}
            {(image && isPreview) ? <img className="max-w-[200px] w-full" src={typeof (image) == "object" ? URL.createObjectURL(image) : image}></img> :
                <div className="border border-dashed border-gray-500 relative rounded-md text-[12px]">
                    <input disabled={disabled} onChange={onChange} type="file" className="cursor-pointer block opacity-0 w-full h-full absolute z-200" />

                    <div className="text-center  w-fit left-0 m-auto p-5">
                        <h4>
                            Drop files anywhere to upload
                            <br />or
                        </h4>
                        <p className="">Select Files</p>
                    </div>

                </div>}
        </div>
    )
}

export default FileInput