import React, { useRef, useState } from 'react'

import Input from '../Input'
import FileInput from '../FileInput'
import Button from '../../Components/Button';

import { useSelector } from 'react-redux'


const HeaderForm = ({ onSubmit = (data) => { }, DefaultData, menus,disabled }) => {

    //state variables
    const [logo, setLogo] = useState(DefaultData?.logo ?? null);
    const [mobileLogo, setMobileLogo] = useState(DefaultData?.mobile_logo ?? null);
    const [headerMenu, setHeaderMenu] = useState(DefaultData?.menu_id ?? null);


    //ref variables
    const textColorRef = useRef(DefaultData?.text_color ?? null)
    const bgColorRef = useRef(DefaultData?.bg_color ?? null)
    const subTextColorRef = useRef(DefaultData?.sub_text_color ?? null)
    const subBgColorRef = useRef(DefaultData?.sub_bg_color ?? null)
    const secondaryColorRef = useRef(DefaultData?.secondary_color ?? null)
    const subSecondaryColorRef = useRef(DefaultData?.sub_secondary_color ?? null)

    const roles = useSelector(state => state.user.roles,disabled)

    const handleFormSubmit = (e) => {

        e.preventDefault();

        onSubmit({
            menu_id: headerMenu,
            text_color: textColorRef.current.value,
            bg_color: bgColorRef.current.value,
            sub_text_color: subTextColorRef.current.value,
            sub_bg_color: subBgColorRef.current.value,
            secondary_color:secondaryColorRef.current.value,
            sub_secondary_color: subSecondaryColorRef.current.value,
            logo: logo,
            mobile_logo: mobileLogo ?? null,
        });
    }


    return (
        <section className='bg-white rounded-[10px] p-5 mt-10'>


            <section className='flex flex-col md:flex-row gap-2 md:gap-5 mb-2'>
                <Input disabled={disabled} DefaultValue={DefaultData?.menu_id ?? null} setState={setHeaderMenu} className="w-full" type={'Select'} label={'Header Menu'}>
                    <option value={null}>Select A HeaderMenu</option>
                    {menus?.length > 0 ?
                        menus?.map(menu => {
                            return (
                                <option value={menu?.id ?? 0} >{menu?.title ?? ''}</option>
                            )
                        })
                        : ''}
                </Input>
                <Input disabled={disabled} DefaultValue={DefaultData?.bg_color ?? '#000000'} ref={bgColorRef} inputClassName="min-h-[42px] bg-white" className="w-full" type="color" label={'Background Color'}></Input>
            </section>
            <section className='flex flex-col md:flex-row gap-2 md:gap-5 mb-2'>
                <Input disabled={disabled} DefaultValue={DefaultData?.text_color ?? '#000000'} ref={textColorRef} inputClassName="min-h-[42px] bg-white" className="w-full" type="color" label={'Text Color'}></Input>
                <Input disabled={disabled} DefaultValue={DefaultData?.sub_bg_color ?? '#000000'} ref={subBgColorRef} inputClassName="min-h-[42px] bg-white" className="w-full" type="color" label={'SubMenu Background Color'}></Input>
            </section>
            <section className='flex flex-col md:flex-row gap-2 md:gap-5 mb-2'>
                <Input disabled={disabled} DefaultValue={DefaultData?.sub_text_color ?? '#000000'} ref={subTextColorRef} inputClassName="min-h-[42px] bg-white" className="w-full" type="color" label={'SubMenu Text Color'}></Input>
                <Input disabled={disabled} DefaultValue={DefaultData?.secondary_color ?? '#000000'} ref={secondaryColorRef} inputClassName="min-h-[42px] bg-white" className="w-full" type="color" label={'Secondary Color'}></Input>

            </section>
            <section className='flex gap-5 mb-2 md:w-1/2'>
                <Input disabled={disabled} DefaultValue={DefaultData?.sub_secondary_color ?? '#000000'} ref={subSecondaryColorRef} inputClassName="min-h-[42px] bg-white" className="w-full" type="color" label={'Sub Secondary Color'}></Input>           
            </section>

            <section className='flex gap-5 mb-2 w-full'>
                <FileInput disabled={disabled} isPreview={true} image={logo} className='w-full' setState={setLogo} >Logo</FileInput>

                <FileInput disabled={disabled} isPreview={true} image={mobileLogo} className='w-full' setState={setMobileLogo} >Mobile Logo</FileInput>
            </section>

            <Button disabled={disabled} onClick={handleFormSubmit} className='mt-10 bg-gray-900 hover:bg-[#000000]  mx-auto'>Save</Button>

        </section>
    )
}

export default HeaderForm