import React, { useRef, useState } from 'react'

import Input from '../Input'
import FileInput from '../FileInput'
import Button from '../Button';

import { useSelector } from 'react-redux'

//fontawesome
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome'
import { faFacebook } from '@fortawesome/free-brands-svg-icons'


const MenuForm = ({ onSubmit = (data) => { }, DefaultData, label = 'Add New Menu' }) => {

    //ref variables
    const titleRef = useRef(DefaultData?.title ?? null)

    const roles = useSelector(state => state.user.roles)

    const handleFormSubmit = (e) => {

        e.preventDefault();

        onSubmit({
            title: titleRef.current.value,

        });
    }

    const isFormDisabled = () => {
        if (DefaultData?.id) {
            return roles?.menuE == false
        }

        return roles?.menuA == false
    }
    return (
        <section className='bg-white rounded-[10px] p-5 mt-10'>
            <h1 class="font-bold text-[22px] mb-5 text-gray-900 text-center md:text-start">{label}</h1>


            <Input disabled={isFormDisabled()} DefaultValue={DefaultData?.title ?? null} ref={titleRef} placeholder={'Title'} className="w-full" label={'Title'}></Input>

            <Button disabled={isFormDisabled()} onClick={handleFormSubmit} className='mt-10 bg-gray-900 hover:bg-[#000000]  mx-auto'>Save</Button>

        </section>
    )
}

export default MenuForm