import React, { useRef, useState } from 'react'

import Input from '../Input'
import FileInput from '../FileInput'
import Button from '../../Components/Button';

import { useSelector } from 'react-redux'

//fontawesome
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome'
import { faFacebook } from '@fortawesome/free-brands-svg-icons'


const PagesForm = ({ onSubmit = (data) => { }, DefaultData, label = 'Add New Page',languages, templates }) => {

    //ref variables
    const titleRef = useRef(DefaultData?.title ?? null)
    const slugRef = useRef(DefaultData?.slug ?? null)
    
    const [status,setStatus] = useState(DefaultData?.published ?? 1)
    const [language,setLanguage] = useState(DefaultData?.lang_id ?? (languages[0]?.id ?? null));
    const [template, setTemplate] = useState(null);

    const roles = useSelector(state => state.user.roles)

    const handleFormSubmit = (e) => {

        e.preventDefault();

        onSubmit({
            title: titleRef.current.value,
            slug: slugRef.current.value,
            lang_id: language,
            status: status,
            template_id: template
        });
    }

    const isFormDisabled = () => {
        if (DefaultData?.id) {
            return roles?.pageE == false
        }

        return roles?.pageA == false
    }
    return (
        <section className='bg-white rounded-[10px] p-5 mt-10'>
            <h1 class="font-bold text-[22px] mb-5 text-gray-900 text-center md:text-start">{label}</h1>

            <section className='flex gap-5 mb-2'>
                <Input disabled={isFormDisabled()} DefaultValue={DefaultData?.title ?? null} ref={titleRef} placeholder={'Title'} className="w-full" label={'Title'}></Input>
                <Input disabled={isFormDisabled()} DefaultValue={DefaultData?.slug ?? null} ref={slugRef} placeholder={'Slug'} className="w-full" label={'Slug'}></Input>
            </section>
            <section className='flex md:w-1/2 gap-5 mb-2 min-w-full'>
                <Input disabled={isFormDisabled()} type="Select" DefaultValue={status ?? null} setState={setStatus} placeholder={'Status'} className="w-full" label={'Status'}>
                    <option value={0}>Unpublished</option>
                    <option value={1}>Published</option>
                </Input>
                <Input disabled={isFormDisabled()} type="Select" DefaultValue={status ?? null} setState={setLanguage} placeholder={'Language'} className="w-full" label={'Language'}>
                    {languages?.map(language => {
                        return(<option value={language?.id}>{language?.name}</option>)
                        }
                    )}
                </Input>
                
                {templates ? 
                <Input disabled={isFormDisabled()} type="Select" DefaultValue={status ?? null} setState={setTemplate} placeholder={'Template'} className="w-full" label={'Template'}>
                    <option value={null}>Choose a template...</option>
                    {templates?.map(template => {
                        return (<option value={template?.id}>{template?.title}</option>)
                    }
                    )}
                </Input>
                : ''}

            </section>
            <Button disabled={isFormDisabled()} onClick={handleFormSubmit} className='mt-10 bg-gray-900 hover:bg-[#000000]  mx-auto'>Save</Button>

        </section>
    )
}

export default PagesForm