import React, { useRef, useState } from 'react'

import Input from '../Input'
import FileInput from '../FileInput'
import Button from '../../Components/Button';

//fontawesome
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome'
import { faFacebook } from '@fortawesome/free-brands-svg-icons'
import TabControl from '../TabControl';
import Tab from '../Tab';
import { FormControlLabel, Switch } from '@mui/material';

import { useSelector } from 'react-redux'
import { faXmark } from '@fortawesome/free-solid-svg-icons';


const UsersForm = ({ onSubmit = (data) => { }, DefaultData, label = 'Add User',profiles }) => {

    //ref variables
    const emailRef = useRef(DefaultData?.email ?? null);
    const nameRef = useRef(DefaultData?.name ?? null);
    const passwordRef = useRef(null);

    const [filter,setFilter] = useState(null);

    const [selectedProfiles, setSelectedProfiles] = useState(DefaultData?.managed_profiles ?? []);

    //privileges
    const [contactsF, setContactsF] = useState(DefaultData?.roles?.contactsF ? parseInt(DefaultData?.roles?.contactsF,10) : null);
    const [contactsA, setContactsA] = useState(DefaultData?.roles?.contactsA ? parseInt(DefaultData?.roles?.contactsA,10) : null);
    const [contactsE, setContactsE] = useState(DefaultData?.roles?.contactsE ? parseInt(DefaultData?.roles?.contactsE,10) : null);
    const [contactsD, setContactsD] = useState(DefaultData?.roles?.contactsD ? parseInt(DefaultData?.roles?.contactsD,10) : null);
    const [contactsP, setContactsP] = useState(DefaultData?.roles?.contactsP ? parseInt(DefaultData?.roles?.contactsP,10) : null);
    const [socialF, setSocialF] = useState(DefaultData?.roles?.socialF   ? parseInt(DefaultData?.roles?.socialF,10) : null);
    const [socialA, setSocialA] = useState(DefaultData?.roles?.socialA   ? parseInt(DefaultData?.roles?.socialA,10) : null);
    const [socialE, setSocialE] = useState(DefaultData?.roles?.socialE   ? parseInt(DefaultData?.roles?.socialE,10) : null);
    const [socialD, setSocialD] = useState(DefaultData?.roles?.socialD   ? parseInt(DefaultData?.roles?.socialD,10) : null);
    const [settingsF, setSettingsF] = useState(DefaultData?.roles?.settingsF ? parseInt(DefaultData?.roles?.settingsF,10) : null);
    const [settingsE, setSettingsE] = useState(DefaultData?.roles?.settingsE ? parseInt(DefaultData?.roles?.settingsE,10) : null);
    const [usersF, setUsersF] = useState(DefaultData?.roles?.usersF    ? parseInt(DefaultData?.roles?.usersF,10) : null);
    const [usersA, setUsersA] = useState(DefaultData?.roles?.usersA    ? parseInt(DefaultData?.roles?.usersA,10) : null);
    const [usersE, setUsersE] = useState(DefaultData?.roles?.usersE    ? parseInt(DefaultData?.roles?.usersE,10) : null);
    const [usersD, setUsersD] = useState(DefaultData?.roles?.usersD    ? parseInt(DefaultData?.roles?.usersD,10) : null);
    const [pageF, setPageF] = useState(DefaultData?.roles?.pageF ? parseInt(DefaultData?.roles?.pageF,10) : null);
    const [pageA, setPageA] = useState(DefaultData?.roles?.pageA ? parseInt(DefaultData?.roles?.pageA,10) : null);
    const [pageE, setPageE] = useState(DefaultData?.roles?.pageE ? parseInt(DefaultData?.roles?.pageE,10) : null);
    const [pageD, setPageD] = useState(DefaultData?.roles?.pageD ? parseInt(DefaultData?.roles?.pageD,10) : null);
    const [pageP, setPageP] = useState(DefaultData?.roles?.pageP ? parseInt(DefaultData?.roles?.pagesP,10) : null);
    const [menuF, setMenuF] = useState(DefaultData?.roles?.menuF ? parseInt(DefaultData?.roles?.menuF,10) : null);
    const [menuA, setMenuA] = useState(DefaultData?.roles?.menuA ? parseInt(DefaultData?.roles?.menuA,10) : null);
    const [menuE, setMenuE] = useState(DefaultData?.roles?.menuE ? parseInt(DefaultData?.roles?.menuE,10) : null);
    const [menuD, setMenuD] = useState(DefaultData?.roles?.menuD ? parseInt(DefaultData?.roles?.menuD,10) : null);
    const [headerF, setHeaderF] = useState(DefaultData?.roles?.headerF ? parseInt(DefaultData?.roles?.headerF,10) : null);
    const [headerE, setHeaderE] = useState(DefaultData?.roles?.headerE ? parseInt(DefaultData?.roles?.headerE,10) : null);
    const [footerF, setFooterF] = useState(DefaultData?.roles?.footerF ? parseInt(DefaultData?.roles?.footerF,10) : null);
    const [dashboard, setDashboard] = useState(DefaultData?.roles?.dashboard ? parseInt(DefaultData?.roles?.dashboard, 10) : null);
    const [languagesF, setLanguagesF] = useState(DefaultData?.roles?.languagesF ? parseInt(DefaultData?.roles?.languagesF,10) : null);
    const [languagesA, setLanguagesA] = useState(DefaultData?.roles?.languagesA ? parseInt(DefaultData?.roles?.languagesA,10) : null);
    const [languagesE, setLanguagesE] = useState(DefaultData?.roles?.languagesE ? parseInt(DefaultData?.roles?.languagesE,10) : null);
    const [languagesD, setLanguagesD] = useState(DefaultData?.roles?.languagesD ? parseInt(DefaultData?.roles?.languagesD,10) : null);
    const [templatesF, setTemplatesF] = useState(DefaultData?.roles?.templatesF ? parseInt(DefaultData?.roles?.templatesF,10) : null);
    const [templatesA, setTemplatesA] = useState(DefaultData?.roles?.templatesA ? parseInt(DefaultData?.roles?.templatesA,10) : null);
    const [templatesE, setTemplatesE] = useState(DefaultData?.roles?.templatesE ? parseInt(DefaultData?.roles?.templatesE,10) : null);
    const [templatesD, setTemplatesD] = useState(DefaultData?.roles?.templatesD ? parseInt(DefaultData?.roles?.templatesD,10) : null);
    const [backup, setBackup] = useState(DefaultData?.roles?.backup ? parseInt(DefaultData?.roles?.backup, 10) : null);
    const [underConstructionF,setUnderConstructionF] = useState(DefaultData?.roles?.underConstructionF ? parseInt(DefaultData?.roles?.underConstructionF,10) : null);

    const roles = useSelector(state => state.user.roles)

    const handleFormSubmit = (e) => {

        e.preventDefault();

        onSubmit({
            name: nameRef.current,
            email: emailRef.current,
            password: passwordRef.current,
            profiles: selectedProfiles,
            roles: {
                contactsF: contactsF,
                contactsA: contactsA,
                contactsE: contactsE,
                contactsD: contactsD,
                contactsP: contactsP,
                socialF: socialF,
                socialA: socialA,
                socialE: socialE,
                socialD: socialD,
                settingsF: settingsF,
                settingsE: settingsE,
                usersF: usersF,
                usersA: usersA,
                usersE: usersE,
                usersD: usersD,
                dashboard: dashboard,
                pageF: pageF,
                pageA: pageA,
                pageE: pageE,
                pageD: pageD,
                pageP: pageP,
                menuF: menuF,
                menuA: menuA,
                menuE: menuE,
                menuD: menuD,
                headerF: headerF,
                headerE: headerE,
                footerF: footerF,
                languagesF: languagesF,
                languagesA: languagesA,
                languagesE: languagesE,
                languagesD: languagesD,
                templatesF: templatesF,
                templatesA: templatesA,
                templatesE: templatesE,
                templatesD: templatesD,
                underConstructionF:underConstructionF,
                backup:backup
            }
        });
    }

    const isFormDisabled = () => {
        if (DefaultData?.id) {
            return roles?.usersE == false
        }

        return roles?.usersA == false
    }

    const filteredProfiles = filter
        ? profiles?.filter(profile =>
            !selectedProfiles?.some(selected => selected.id === profile.id) &&
            (
                profile?.name?.toLowerCase().includes(filter.toLowerCase()) ||
                profile?.address?.toLowerCase().includes(filter.toLowerCase()) ||
                profile?.number?.toLowerCase().includes(filter.toLowerCase()) ||
                profile?.mobile?.toLowerCase().includes(filter.toLowerCase()) ||
                profile?.code?.toLowerCase().includes(filter.toLowerCase())
            )
        )
        : [];

        const handleAddProfile = (id) => {
            const selectedProfile = profiles?.find(profile => profile?.id == id);
            if (!selectedProfiles.some(profile => profile?.id == id)) {
            setSelectedProfiles([...selectedProfiles, selectedProfile]);
            }
        }

        const hanldeRemoveProfile = (id) => {

            if (selectedProfiles.some(profile => profile?.id == id)) {
                setSelectedProfiles(selectedProfiles.filter(profile => profile?.id != id));
            }
        }

    return (
        <section className='bg-white rounded-[10px] p-5 mt-10'>
            <h1 class="font-bold text-[22px] mb-5 text-gray-900 text-center md:text-start">{label}</h1>

            <TabControl>
                <Tab name="General">
                    <section className='flex gap-5 mb-2'>
                        <Input disabled={DefaultData?.email || isFormDisabled()} DefaultValue={emailRef.current ?? null} type="email" setState={(value) => emailRef.current = value} placeholder={'test@test.com'} className="w-full mb-2" label={'Email'}></Input>
                        <Input disabled={isFormDisabled()} DefaultValue={nameRef.current ?? null} setState={(value) => nameRef.current = value} placeholder={'Lorem Ipsum'} className="w-full mb-2" label={'Name'}></Input>
                    </section>
                    <section className='flex gap-5 mb-2'>
                        <Input disabled={isFormDisabled()} type="password" setState={(value) => passwordRef.current = value} placeholder={'*****'} className="md:w-1/2 w-full mb-2" label={'Password'}></Input>
                    </section>
                </Tab>
                <Tab name="Privileges">
                    <FormControlLabel disabled={isFormDisabled()} checked={dashboard} onChange={(e) => { setDashboard(e.target.checked) }} className='mb-2' control={<Switch />} label="Dashboard" />
                    <FormControlLabel disabled={isFormDisabled()} checked={backup} onChange={(e) => { setBackup(e.target.checked) }} className='mb-2' control={<Switch />} label="Backup" />
                    <FormControlLabel disabled={isFormDisabled()} checked={underConstructionF} onChange={(e) => { setUnderConstructionF(e.target.checked) }} className='mb-2' control={<Switch />} label="Under Construction" />
                    <FormControlLabel disabled={isFormDisabled()} checked={contactsF} onChange={(e) => { setContactsF(e.target.checked) }} className='mb-2' control={<Switch />} label="Contacts Module" />
                    <section className='flex gap-5 mb-7'>
                        <FormControlLabel disabled={!contactsF || isFormDisabled()} checked={contactsA} onChange={(e) => { setContactsA(e.target.checked) }} control={<Switch />} label="Add" />
                        <FormControlLabel disabled={!contactsF || isFormDisabled()} checked={contactsE} onChange={(e) => { setContactsE(e.target.checked) }} control={<Switch />} label="Edit" />
                        <FormControlLabel disabled={!contactsF || isFormDisabled()} checked={contactsD} onChange={(e) => { setContactsD(e.target.checked) }} control={<Switch />} label="Delete" />
                        <FormControlLabel disabled={!contactsF || isFormDisabled()} checked={contactsP} onChange={(e) => { setContactsP(e.target.checked) }} control={<Switch />} label="Publish" />

                    </section>



                    <FormControlLabel disabled={isFormDisabled()} checked={socialF} onChange={(e) => { setSocialF(e.target.checked) }} className='mb-2' control={<Switch />} label="Social Links Module" />
                    <section className='flex gap-5 mb-7'>
                        <FormControlLabel disabled={!socialF || isFormDisabled()} checked={socialA} onChange={(e) => { setSocialA(e.target.checked) }} control={<Switch />} label="Add" />
                        <FormControlLabel disabled={!socialF || isFormDisabled()} checked={socialE} onChange={(e) => { setSocialE(e.target.checked) }} control={<Switch />} label="Edit" />
                        <FormControlLabel disabled={!socialF || isFormDisabled()} checked={socialD} onChange={(e) => { setSocialD(e.target.checked) }} control={<Switch />} label="Delete" />
                    </section>

                    <FormControlLabel disabled={isFormDisabled()} checked={pageF} onChange={(e) => { setPageF(e.target.checked) }} className='mb-2' control={<Switch />} label="Pages Module" />
                    <section className='flex gap-5 mb-7'>
                        <FormControlLabel disabled={!pageF || isFormDisabled()} checked={pageA} onChange={(e) => { setPageA(e.target.checked) }} control={<Switch />} label="Add" />
                        <FormControlLabel disabled={!pageF || isFormDisabled()} checked={pageE} onChange={(e) => { setPageE(e.target.checked) }} control={<Switch />} label="Edit" />
                        <FormControlLabel disabled={!pageF || isFormDisabled()} checked={pageD} onChange={(e) => { setPageD(e.target.checked) }} control={<Switch />} label="Delete" />
                        <FormControlLabel disabled={!pageF || isFormDisabled()} checked={pageP} onChange={(e) => { setPageP(e.target.checked) }} control={<Switch />} label="Publish" />
                    </section>

                    <FormControlLabel disabled={isFormDisabled()} checked={menuF} onChange={(e) => { setMenuF(e.target.checked) }} className='mb-2' control={<Switch />} label="Menus Module" />
                    <section className='flex gap-5 mb-7'>
                        <FormControlLabel disabled={!menuF || isFormDisabled()} checked={menuA} onChange={(e) => { setMenuA(e.target.checked) }} control={<Switch />} label="Add" />
                        <FormControlLabel disabled={!menuF || isFormDisabled()} checked={menuE} onChange={(e) => { setMenuE(e.target.checked) }} control={<Switch />} label="Edit" />
                        <FormControlLabel disabled={!menuF || isFormDisabled()} checked={menuD} onChange={(e) => { setMenuD(e.target.checked) }} control={<Switch />} label="Delete" />
                    </section>

                    <section className='mb-7'>
                        <FormControlLabel disabled={isFormDisabled()} checked={headerF} onChange={(e) => { setHeaderF(e.target.checked) }} control={<Switch />} label="Header Module" />
                        <FormControlLabel disabled={!headerF || isFormDisabled()} checked={headerE} onChange={(e) => { setHeaderE(e.target.checked) }} control={<Switch />} label="Edit" />
                    </section>



                    <section className='mb-7'>
                        <FormControlLabel disabled={isFormDisabled()} checked={footerF} onChange={(e) => { setFooterF(e.target.checked) }} control={<Switch />} label="Footer Module" />
                    </section>

                    <FormControlLabel disabled={isFormDisabled()} checked={languagesF} onChange={(e) => { setLanguagesF(e.target.checked) }} className='mb-2' control={<Switch />} label="Languages Module" />
                    <section className='flex gap-5 mb-7'>
                        <FormControlLabel disabled={!languagesF || isFormDisabled()} checked={languagesA} onChange={(e) => { setLanguagesA(e.target.checked) }} control={<Switch />} label="Add" />
                        <FormControlLabel disabled={!languagesF || isFormDisabled()} checked={languagesE} onChange={(e) => { setLanguagesE(e.target.checked) }} control={<Switch />} label="Edit" />
                        <FormControlLabel disabled={!languagesF || isFormDisabled()} checked={languagesD} onChange={(e) => { setLanguagesD(e.target.checked) }} control={<Switch />} label="Delete" />
                    </section>

                    

                    <section className='mb-7'>
                        <FormControlLabel disabled={isFormDisabled()} checked={settingsF} onChange={(e) => { setSettingsF(e.target.checked) }} control={<Switch />} label="Settings Module" />
                        <FormControlLabel disabled={!settingsF || isFormDisabled()} checked={settingsE} onChange={(e) => { setSettingsE(e.target.checked) }} control={<Switch />} label="Edit" />
                    </section>


                    <FormControlLabel disabled={isFormDisabled()} checked={usersF} onChange={(e) => { setUsersF(e.target.checked) }} className='mb-2' control={<Switch />} label="Users Module" />
                    <section className='flex gap-5 mb-7'>
                        <FormControlLabel disabled={!usersF || isFormDisabled()} checked={usersA} onChange={(e) => { setUsersA(e.target.checked) }} control={<Switch />} label="Add" />
                        <FormControlLabel disabled={!usersF || isFormDisabled()} checked={usersE} onChange={(e) => { setUsersE(e.target.checked) }} control={<Switch />} label="Edit" />
                        <FormControlLabel disabled={!usersF || isFormDisabled()} checked={usersD} onChange={(e) => { setUsersD(e.target.checked) }} control={<Switch />} label="Delete" />
                    </section>

                    

                    <FormControlLabel disabled={isFormDisabled()} checked={templatesF} onChange={(e) => { setTemplatesF(e.target.checked) }} className='mb-2' control={<Switch />} label="Templates Module" />
                    <section className='flex gap-5'>
                        <FormControlLabel disabled={!templatesF || isFormDisabled()} checked={templatesA} onChange={(e) => { setTemplatesA(e.target.checked) }} control={<Switch />} label="Add" />
                        <FormControlLabel disabled={!templatesF || isFormDisabled()} checked={templatesE} onChange={(e) => { setTemplatesE(e.target.checked) }} control={<Switch />} label="Edit" />
                        <FormControlLabel disabled={!templatesF || isFormDisabled()} checked={templatesD} onChange={(e) => { setTemplatesD(e.target.checked) }} control={<Switch />} label="Delete" />
                    </section>
                </Tab>
                <Tab className={'min-h-[500px]'} name="Profiles Manage">
                    <section className='flex gap-2 justify-start flex-wrap'>
                        {selectedProfiles?.map(profile => {
                        return (
                           <div onClick={()=>{hanldeRemoveProfile(profile?.id)}} key={profile?.id} className='rounded-md bg-gray-900 text-white flex gap-2 items-center justify-center items-center px-2 py-1 cursor-pointer'>{profile?.code}<FontAwesomeIcon className='' icon={faXmark}></FontAwesomeIcon></div>
                        )
                    })}
                    </section>
                    <Input className={'w-1/2'} onSelectionClick={handleAddProfile} selections={filteredProfiles} setState={setFilter} criteria={'code'} type="text-with-search" suggestions={profiles} label="Profiles"></Input>

                </Tab>

            </TabControl>

            <Button disabled={isFormDisabled()} onClick={handleFormSubmit} className='mt-10 bg-gray-900 hover:bg-[#000000]  mx-auto'>Save</Button>

        </section>
    )
}

export default UsersForm