import React, { forwardRef } from 'react'

import Label from './Label'

const Input = forwardRef(({ DefaultValue = null, value = null, label = '', className = '', inputClassName = 'min-w-[124px]', type = 'text', labelClassName = 'ml-2', inputProps, children, placeholder = '', setState = null, disabled = false, selections = [], criteria, onSelectionClick, onBlur = (e) => { setState(e.target.value) }, onChange= null }, ref) => {

  if(type == 'textarea'){
    return (
      <div className={className}>
        <Label labelClassName={labelClassName}>{label}</Label>
        <textarea defaultValue={DefaultValue ?? null} onChange={onChange} {...inputProps} type={type} ref={ref} placeholder={placeholder} className={`${inputClassName} w-full rounded-md px-1 py-2 border border-solid focus:border-2 focus:border-[#21659B] border-gray-900`}></textarea>
      </div>
    )
  }

  if(type == "Select"){
    return (
      <div className={className}>
        {label ? <Label labelClassName={labelClassName}>{label}</Label> : ''}
        <select disabled={disabled} defaultValue={DefaultValue ?? null} onChange={(e)=>{setState(e.target.value)}} {...inputProps} type={type} ref={ref} placeholder={placeholder} className={`${inputClassName} w-full rounded-md px-1 py-2 border border-solid focus:border-2 focus:border-[#21659B] border-gray-900`}>
          {children ?? ''}
        </select>
      </div>
    )
  }

  if(type === "Date"){
    return (
      <div className={className}>
        <Label labelClassName={labelClassName}>{label}</Label>
        <input disabled={disabled} DefaultValue={DefaultValue ?? null} onChange={onChange} onBlur={(content)=>{setState(content)}} {...inputProps} type={type} ref={ref} className={`${inputClassName} w-full rounded-md px-1 py-2 border border-solid focus:border-2 focus:border-[#21659B] border-gray-900`}></input>
      </div>
    )
  }

  if(type == "text-with-search"){
    return (
      <div className={className}>
        <Label labelClassName={labelClassName}>{label}</Label>
        <section className='relative'>
        <input disabled={disabled} onBlur={onBlur} defaultValue={DefaultValue ?? null} onChange={onChange} {...inputProps} type={type} ref={ref} placeholder={placeholder} className={`${inputClassName} w-full rounded-md px-1 py-2 border border-solid focus:border-2 focus:border-[#21659B] border-gray-900`}></input>
          {selections?.length >=1 ? 
          <div className="absolute max-h-[100px] overflow-y-auto rounded-md overflow-hidden right-0 top-full  bg-white w-[200px] border border-solid border-gray-900 border-collapse">
            {selections?.map(selection=>{
              return (
                <div onClick={()=>{onSelectionClick(selection?.id)}} key={selection?.id} className='cursor-pointer py-1.5 px-1 border-b border-gray-900 hover:bg-gray-200 duration-[300ms]' >{selection?.[criteria]}</div>
              )
            })}
            
          </div>
            : ''}
        </section>
      </div>
    )
  }

  return (
    <div className={className}>
          <Label labelClassName={labelClassName}>{label}</Label>
      <input  readOnly={false} disabled={disabled} onBlur={onBlur} value={value ?? null} defaultValue={DefaultValue ?? null} onChange={onChange} {...inputProps} type={type} ref={ref} placeholder={placeholder} className={`${inputClassName} w-full rounded-md px-1 py-2 border border-solid focus:border-2 focus:border-[#21659B] border-gray-900`}></input>
    </div>
  )
})

export default Input