import { faArrowDown, faPlus } from '@fortawesome/free-solid-svg-icons'
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome'

import Input from '../Input'
import React from 'react'

import { v4 as uuidv4 } from 'uuid';

import {
    useSortable,
} from '@dnd-kit/sortable';

import { CSS } from '@dnd-kit/utilities';


import { Accordion, AccordionSummary, AccordionDetails} from '@mui/material'; // Or your custom components
import SortableWidget from '../SortableWidget';

const MenuChildComponents = ({items,item,onDragEnd,onUpdateMenuItem,onDeleteMenuItem}) => {
    const children = items?.filter(childItem => childItem?.parent_id == item?.id);

    if(children.length <= 0){
        return null;
    }



    return (
    <section className="ml-10">
            <SortableWidget items={children} onDragEnd={onDragEnd}>
            {children.map(child=> {
                return (<MenuItemSortable key={child?.id ?? uuidv4()} onDragEnd={onDragEnd} onDeleteMenuItem={onDeleteMenuItem} onUpdateMenuItem={ onUpdateMenuItem } items={items} item={child}></MenuItemSortable>)
            })}
            
        </SortableWidget>
        </section>
    )
}


const MenuItemSortable = ({ item, items, onDeleteMenuItem, onUpdateMenuItem, onDragEnd }) => {

    const {
    attributes,
    listeners,
    setNodeRef,
    transform,
    transition,
  } = useSortable({id: item.id});

  const style = {
    transform: CSS.Transform.toString(transform),
    transition,
  };



    return (
        <>
        <section ref={setNodeRef} style={style} {...attributes} {...listeners}>
            <Accordion  slotProps={{ heading: { component: 'h4' } }}>
            <AccordionSummary
                    
                expandIcon={<FontAwesomeIcon icon={faArrowDown} />}
                aria-controls="panel1-content"
                id="panel1-header"
            >
                {item?.title ?? 'title'}
                <span className="rounded-[10px] text-white bg-gray-900 ml-12 px-3 py-1 text-[12px] flex items-center justify-center">{item?.type ?? ''}</span>
            </AccordionSummary>
            <AccordionDetails>
                    
                <Input onBlur={(e) => { onUpdateMenuItem({ key: 'title', value: e.target.value, id: item?.id ?? 1 }) }} DefaultValue={item?.title} label={'Title'}></Input>
                {item?.type == 'link' ? <Input onBlur={(e) => { onUpdateMenuItem({ key: 'link', value: e.target.value, id: item?.id ?? 1 }) }} DefaultValue={item?.link} label={'Link'}></Input> : ''}
                <span onClick={() => { onDeleteMenuItem(item?.id) }} className={'text-red-500  cursor-pointer'}>Remove</span>
            </AccordionDetails>
        </Accordion>
        </section>
            <MenuChildComponents onDeleteMenuItem={onDeleteMenuItem} onUpdateMenuItem={onUpdateMenuItem} onDragEnd={onDragEnd} items={items} item={item}></MenuChildComponents>

        </>
    )
}

export default MenuItemSortable