import { faBars } from '@fortawesome/free-solid-svg-icons'
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome'
import React, { use } from 'react'

import {  useDispatch,useSelector } from 'react-redux'
import { toggleSidebarVisibility } from '../store/slices/sidebarSlice'

const MobileBar = () => {
    const dispatch = useDispatch();
  const isOpened = useSelector(state => state.sidebar.visibility);

    const handleToggleSidebar = () => {
        dispatch(toggleSidebarVisibility());
    }

  return (
    <section className={`max-md:w-full sticky max-md:top-0 z-[100]  max-md:px-4  max-md:h-[62px]  md:fixed md:top-0 md:left-0 p-2 flex justify-between items-center gap-5 duration-[300ms] ${isOpened ? 'md:bg-white bg-gray-900 md:text-gray-900 text-white ' : 'bg-gray-900 text-white'}`}>
      <img className='md:hidden w-[110px]' src={'/storage/app/public/assets/Logo.png'} />
        <FontAwesomeIcon onClick={handleToggleSidebar} className={`text-[20px] duration-[300ms] ${isOpened ? 'rotate-90' : ''}`} icon={faBars} />
    </section>
  )
}

export default MobileBar