
import React,{useRef} from 'react'

import { faSearch } from '@fortawesome/free-solid-svg-icons'
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome'


const SearchBar = ({ className = '', onChange=()=>{} , onSearch = (data) => { }, onBlur = () => { }, onKeyDown = (e) => {
    //checks if Enter key was pressed
    if(e.key == 'Enter'){
        
        onSearch(ref.current.value);
    }
} , ref = useRef(null)}) => {
  return (
      <div className={`${className} relative text-gray-600 w-fit`}>
          <input onKeyDown={onKeyDown} onChange={onChange} onBlur={onBlur} ref={ref} className="border-2 border-gray-300 bg-white h-10 px-5 pr-16 rounded-lg text-sm focus:outline-none"
              type="search" name="search" placeholder="Search" />
              <button  onClick={()=>{onSearch(ref.current.value)}} className="absolute right-4 top-[50%] -translate-y-[50%] ">
                  <FontAwesomeIcon icon={faSearch}  />
              </button>
      </div>
  )
}

export default SearchBar