import React from 'react'
import SideBarItems from '../Data/SideBar'
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome'

import { useSelector } from 'react-redux'
import { Link } from '@inertiajs/react'
import Button from './Button'

import { router } from '@inertiajs/react'

const SideBar = () => {
  const visibile = useSelector(state => state.sidebar.visibility)

  const roles = useSelector(state => state.user.roles)
  const email = useSelector(state => state.user.email)

  const handleLogout = () => {
    router.post('/admin/logout');
  }


  if (visibile == true) {
    return (
      <aside class=" max-md:fixed max-md:mt-[62px] left-0 top-0 bottom-0 z-[9999] flex flex-col w-64 min-w-[224px] min-h-screen min-h-full  overflow-y-auto  border-r rtl:border-r-0 rtl:border-l bg-gray-900 border-gray-700">
        <Link href={'/admin/dashboard'} class="p-[26px] bg-white max-md:hidden">
          <img src={'/storage/app/public/assets/Logo.png'} />
        </Link>
        <div className='bg-white px-[26px] py-1 flex items-center justify-center'>{email ?? ''}</div>

        <Button onClick={handleLogout} className='border-t-0 bg-[#297EC0] hover:bg-[#21659B]'>Logout</Button>

        <div class="flex flex-col justify-between flex-1 mt-6 px-5">
          <nav class="-mx-3 space-y-6 ">
            {SideBarItems.sections.map(section => {
                const hasVisibleItems = section.items.some(item => item?.role == null || roles[item?.role] == true);

                if (!hasVisibleItems) {
                return null;
                }

                return (
                <div class="space-y-3 ">
                  <label class="px-3 text-xs uppercase text-gray-400">{section.name}</label>

                  {section.items.map(item => {
                  if (item?.role == null || roles[item?.role] == true) {
                    if (item?.target == '_blank') {
                    return (
                      <a
                      target='_blank'
                      className="flex gap-4 items-center px-3 py-2 transition-colors duration-300 transform rounded-lg text-gray-200 hover:bg-gray-800 hover:text-gray-200"
                      href={item.url}
                      >
                      <FontAwesomeIcon class="w-5" icon={item.icon} />
                      <span class="text-sm font-medium">{item.name}</span>
                      </a>
                    );
                    }

                    return (
                    <Link
                      className="flex gap-4 items-center px-3 py-2 transition-colors duration-300 transform rounded-lg text-gray-200 hover:bg-gray-800 hover:text-gray-200"
                      href={item.url}
                    >
                      <FontAwesomeIcon class="w-5" icon={item.icon} />
                      <span class="text-sm font-medium">{item.name}</span>
                    </Link>
                    );
                  }
                  })}
                </div>
                );
            })}

          </nav>
        </div>
      </aside>
    )
  }

}

export default SideBar