import React, { useEffect, useRef } from "react";

const SlideShow = ({ children, duration = 3000, gap = 28, className = "" }) => {
    const sliderRef = useRef(null);
    const slides = children?.length ?? 0;

    useEffect(() => {


        const slider = sliderRef.current;
        if (!slider || slides === 0) return;

        const autoScroll = () => {
            if (!slider) return;

            const slideWidth = slider.firstChild?.offsetWidth + gap || 250;

            if (slider.scrollLeft + slider.clientWidth >= slider.scrollWidth - 1) {
                // Reset to start instantly (to avoid visible jump)
                slider.scrollTo({ left: 0, behavior: "instant" });
            } else {
                slider.scrollBy({ left: slideWidth, behavior: "smooth" });
            }
        };

        const interval = setInterval(autoScroll, duration);

        return () => clearInterval(interval); // Cleanup on unmount
        
    }, [duration, slides, gap]);

    return (
        <section
            ref={sliderRef}
            style={{ gap: `${gap}px` }}
            className={`${className} flex justify-start items-center overflow-x-auto scrollbar-hide whitespace-nowrap mx-auto`}
        >
            {children}
        </section>
    );
};

export default SlideShow;
