import React from 'react'

import {
    DndContext,
    closestCenter,
    PointerSensor,
    useSensor,
    useSensors
} from '@dnd-kit/core';


import {
    arrayMove,
    SortableContext,
    verticalListSortingStrategy
} from '@dnd-kit/sortable';

const SortableWidget = ({ children, items, onDragEnd }) => {
    const sensors = useSensors(
        useSensor(PointerSensor, {
            activationConstraint: { distance: 8 }
        })
    );

  return (
      <DndContext sensors={sensors} collisionDetection={closestCenter} onDragEnd={onDragEnd}> <SortableContext items={items.map(item => item?.id)} strategy={verticalListSortingStrategy}>

        {children ?? ''}
      </SortableContext></DndContext>
  )
}

export default SortableWidget