import React,{useState} from 'react'

const BlocksCard = ({block: {
    background = "#FFFFFF",
    image = '',
    title = "Title",
    description = "Description",
    button = "Button",
    link = "#",
}}) => {

    const [isReadMore,setIsReadMore] = useState(true);

    const toggleReadMore = () => {
        setIsReadMore(!isReadMore);
    }
  return (
      <div className=" mx-auto w-full">

          <div style={{ backgroundColor: background ?? 'white' }} className="relative flex flex-col justify-between overflow-hidden   text-gray-700 shadow-lg p-4 h-full border border-solid border-gray-900 rounded-[10px]">
            <section>
              {image ? <div className="relative m-0 overflow-hidden text-gray-700">
                  <img
                      className="h-[150px] md:h-[200px] object-contain md:object-cover w-full"
                      loading="lazy"
                      src={`${image}`}
                  />
                  </div> : ''}
              <div className="mt-3 ">
                  <h4 dangerouslySetInnerHTML={{ __html: title ?? '' }} className="text-start text-[18px] md:text-[22px] font-semibold  text-blue-gray-900">
                    
                  </h4>
                  
                  <p dangerouslySetInnerHTML={{ __html: (description.length > 75 && isReadMore) ? `${description.slice(0, 75)}...` : description ?? '' }} className="text-start mt-2 font-normaltext-gray-700 text-[12px] md:text-[16px]">
                  </p>
                  {description.length > 75 ? <span onClick={toggleReadMore} className="text-start mt-2 font-normal text-gray-700 text-[12px] md:text-[16px] cursor-pointer">{isReadMore ? 'Read More...' : 'Show Less...'}</span> : '' }
              </div>
              </section>
              {button ? <div className="flex items-center">
                  <a target="_blank" dangerouslySetInnerHTML={{ __html: button ?? '' }} className="mt-2 text-[12px] md:text-[16px] cursor-pointer" href={`${link}`}></a>
              </div> : '' }
          </div>
      </div>
  )
}

export default BlocksCard