import React, { useRef } from 'react';
import { router } from "@inertiajs/react";
import Button from '../../Components/Button';

import useHandleToastMessages from '../../hooks/useHandleToastMessages';
import { toast } from 'react-toastify';



const ForgetPassword = ({ messages }) => {
    useHandleToastMessages(messages);

    //define ref variables
    const emailRef = useRef(null);

    //submit function
    const handleForgetPassword = (e) => {
        e.preventDefault();

        if (emailRef.current.value === '' || !emailRef.current.value) {
            toast.error('Email is required');
        }

        router.post("/password-forget", { email: emailRef.current.value });
    }


    return (

        <div className="relative flex min-h-screen text-gray-800 antialiased flex-col justify-center overflow-hidden bg-gray-50 py-6 sm:py-12">
            <div className="relative py-3 sm:w-96 mx-auto text-center">
                <span className="text-2xl font-light ">Reset Password</span>
                <div className="mt-4 bg-white shadow-md rounded-lg text-left">
                    <div className={`h-2  rounded-t-md ${messages?.errors ? 'bg-red-500' : 'bg-[#297EC0]'}`}></div>
                    <form onSubmit={handleForgetPassword}>
                        <div className="px-8 py-6 ">
                            <label className={`block font-semibold ${messages?.errors ? 'text-red-500' : ''}`}>Email</label>
                            <input ref={emailRef} type="text" placeholder="Email" className={` w-full h-5 px-3 py-5 mt-2 hover:outline-none focus:outline-none focus:ring-indigo-500 focus:ring-1 rounded-md ${messages?.errors ? 'border-red-500 border-2 text-red-500' : 'border'}`} />
                            <Button className='mt-5 bg-[#297EC0] hover:bg-[#21659B]'>Reset Password Email</Button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    )
}

export default ForgetPassword