import React, { useRef, useEffect } from 'react'
import { router, usePage } from "@inertiajs/react";
import Button from '../../Components/Button';




import { toast } from 'react-toastify';
import useHandleToastMessages from '../../hooks/useHandleToastMessages';



const ResetPassword = ({ messages }) => {
    useHandleToastMessages(messages);

    //define ref variables
    const emailRef = useRef(null);
    const passwordRef = useRef(null);
    const confirmPasswordRef = useRef(null);

    const { url } = usePage(); // full URL including query
    
    // 1. Extract query parameters (e.g., email)
    const queryString = url.split('?')[1] || '';
    const queryParams = new URLSearchParams(queryString);
    const email = queryParams.get('email');

    // 2. Extract token from the URL path
    const token = url.split('/reset-password/')[1]?.split('?')[0];

    //submit function
    const handleResetPassword = (e) => {
        e.preventDefault();

        if(confirmPasswordRef.current.value != passwordRef.current.value){
            toast.error('Passwords do not match');
        }

        router.post("/password-reset", { email: emailRef.current.value, password: passwordRef.current.value,token:token });
    }


    return (

        <div className="relative flex min-h-screen text-gray-800 antialiased flex-col justify-center overflow-hidden bg-gray-50 py-6 sm:py-12">
            <div className="relative py-3 sm:w-96 mx-auto text-center">
                <span className="text-2xl font-light ">Reset Password</span>
                <div className="mt-4 bg-white shadow-md rounded-lg text-left">
                    <div className={`h-2  rounded-t-md ${messages?.errors ? 'bg-red-500' : 'bg-[#297EC0]'}`}></div>
                    <form onSubmit={handleResetPassword}>
                        <div className="px-8 py-6 ">
                            <label className={`block font-semibold ${messages?.errors ? 'text-red-500' : ''}`}>Email</label>
                            <input defaultValue={email??''} disabled={true} ref={emailRef} type="text" placeholder="Email" className={` w-full h-5 px-3 py-5 mt-2 hover:outline-none focus:outline-none focus:ring-indigo-500 focus:ring-1 rounded-md ${messages?.errors ? 'border-red-500 border-2 text-red-500' : 'border'}`} />
                            <label className={`block font-semibold mt-3 ${messages?.errors ? 'text-red-500' : ''}`}>Password</label>
                            <input ref={passwordRef} type="password" placeholder="Password" className={`border w-full h-5 px-3 py-5 mt-2 hover:outline-none focus:outline-none focus:ring-indigo-500 focus:ring-1 rounded-md ${messages?.errors ? 'border-red-500 border-2 text-red-500' : 'border'}`} />
                            <label className={`block font-semibold mt-3 ${messages?.errors ? 'text-red-500' : ''}`}>Confirm Password</label>
                            <input ref={confirmPasswordRef} type="password" placeholder="Password" className={`border w-full h-5 px-3 py-5 mt-2 hover:outline-none focus:outline-none focus:ring-indigo-500 focus:ring-1 rounded-md ${messages?.errors ? 'border-red-500 border-2 text-red-500' : 'border'}`} />
                            <Button className='mt-5 bg-[#297EC0] hover:bg-[#21659B]'>Reset Password</Button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

    )
}

export default ResetPassword