import React from "react"


import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';

import { Splide, SplideSlide } from '@splidejs/react-splide';
import '@splidejs/react-splide/css';


import { faDownload, faIdCard, faPen, faPhone } from "@fortawesome/free-solid-svg-icons";

import useHandleToastMessages from "../../../hooks/useHandleToastMessages";
import { useSelector } from "react-redux";
import BlocksCard from "../../../Components/template1/BlocksCard";
import ServicesCard from "../../../Components/template1/ServicesCard";


import { toast } from "react-toastify";
import useWriteNfc from "../../../hooks/useWriteNfc";






export default function Index({ app, auth, messages }) {
    useHandleToastMessages(messages);

    const roles = useSelector(state => state.user.roles);
 
    const {isWriting,writeNfc} = useWriteNfc();


    /*
    const handleWriteNfc = async () => {
        if ("NDEFReader" in window) {
            const ndef = new NDEFReader();
            try {
                toast.info("Approach your NFC Card!");

                await ndef.write({
                    records: [
                        {
                            recordType: "url",
                            data: window.location.href,
                        },
                    ],
                });

                toast.success("NDEF message written!");
            } catch (error) {
                toast.error(error);
            }
        } else {
            toast.error("Web NFC is not supported.");
        }
    }*/


        const handleWriteNfc = async () => {
            writeNfc({message:window.location.href});
        }


    return (
        <div className="">

            
            <div class=" mx-auto">
                <div class="bg-white rounded-md text-center">
                    <section class="relative mb-10">
                        <img class="w-full max-h-[350px] object-cover md:object-contain d-block" src={`${app.cover_pic != '' ? app.cover_pic : '/storage/app/public/assets/cover.png'}`} alt="" />
                        <img src={`${app.profile_pic != '' ? app.profile_pic : (app?.gender == 'Female' ? '/storage/app/public/assets/profile-Female.png' : '/storage/app/public/assets/profile.png')}`} alt="" class="rounded-full shadow-lg-md border-4 border-white mx-auto absolute left-1/2 bottom-[0px] translate-y-[50%] -translate-x-[50%] w-[112px] aspect-square object-cover" />
                    </section>
                    <div class="p-7">
                        <h3 dangerouslySetInnerHTML={{ __html: app?.name ?? '' }}
                            class="text-xl font-bold mb-2"></h3>
                        <h3 class="text-xl font-bold mb-2">{auth?.user?.name ?? ''}</h3>

                        <p dangerouslySetInnerHTML={{ __html: app?.address ?? '' }} class="text-gray-500 max-w-[200px] md:max-w-[400px] mx-auto mb-2 font-bold"></p>
                        <p dangerouslySetInnerHTML={{ __html: app?.description ?? '' }} class="text-gray-500 max-w-[400px] md:max-w-[600px] mx-auto"></p>
                        <div className="flex  justify-center w-fit mx-auto gap-2 mt-5">
                            <a href={`/${app.code}/vcard`} class="flex text-[12px] items-center justify-center gap-2  mx-auto w-fit text-white bg-gray-600 py-2 px-5 rounded-[9px]"><FontAwesomeIcon icon={faDownload} /> Save Contact</a>
                            {roles?.contactsP ? <div onClick={handleWriteNfc} class="flex min-w-[34px] text-[12px] items-center justify-center gap-2 mx-auto w-fit text-white bg-gray-600 py-2 px-2 rounded-[9px] min-h-full w-auto aspect-square cursor-pointer"><FontAwesomeIcon icon={faIdCard} /> </div> : ''}
                            {app?.mobile ? <a href={`tel:${app.mobile}`} class="flex min-w-[34px] text-[12px] items-center justify-center gap-2 mx-auto w-fit text-white bg-gray-600 py-2 px-2 rounded-[9px] min-h-full w-auto aspect-square"><FontAwesomeIcon icon={faPhone} > </FontAwesomeIcon> </a> : ''}
                            { }

                            {roles?.contactsE == true ? <a href={`/admin/contacts/${app?.id}/edit`} class="flex min-w-[34px] text-[12px] items-center justify-center gap-2 mx-auto w-fit text-white bg-gray-600 py-2 px-2 rounded-[9px] min-h-full w-auto aspect-square"><FontAwesomeIcon icon={faPen} > </FontAwesomeIcon> </a> : (app?.can_edit == true ? <a href={`/admin/profiles/${app?.id}/edit`} class="flex min-w-[34px] text-[12px] items-center justify-center gap-2 mx-auto w-fit text-white bg-gray-600 py-2 px-2 rounded-[9px] min-h-full w-auto aspect-square"><FontAwesomeIcon icon={faPen} > </FontAwesomeIcon> </a> : '')}
                        </div>

                        <div class=" grid grid-cols-3 md:grid-cols-4  flex-wrap w-fit mx-auto items-center justify-start gap-10 mt-7">
                            {app.social_links ? app.social_links.map((social_link, index) => {
                                return <a href={`${social_link?.social_type?.base_url ?? ''}${social_link?.link ?? ''}${social_link?.social_type?.enc_url ?? ''}`} style={{ backgroundColor: social_link?.social_type?.color ?? '#000000' }} class="text-white col-auto fill-white p-1  rounded-full flex items-center justify-center h-12 w-12 *:w-full *:h-full"
                                    dangerouslySetInnerHTML={{ __html: social_link?.social_type?.icon ?? '' }}
                                >

                                </a>
                            }) : ''}

                        </div>
                        <section className="mt-14">
                            <img className=" mb-7 mx-auto w-[100px]" src={`https://api.qrserver.com/v1/create-qr-code/?data=${window.location.href}&size=150x150`}></img>
                            <a target="_blank" className="rounded-lg text-white mt-5 bg-[#000000] px-5 py-3" href={`https://api.qrserver.com/v1/create-qr-code/?data=${window.location.href}&size=150x150`}>Download Qr Code</a>
                        </section>


                        {(app?.embeds_section && app?.embeds?.length > 0 ) ? <section className="flex flex-col gap-3 md:gap-7 mt-14">

                        {app?.embeds_section ? <h3 dangerouslySetInnerHTML={{ __html: app?.embeds_section ?? '' }} className='text-[22px] md:text-[32px] text-gray-900 font-bold mx-auto'></h3> : ''}
                        {app?.embeds?.length > 0 ? <Splide
                            options={{
                                perPage: 2,
                                type: 'loop',
                                gap: '1.25rem',
                                autoplay: true,
                                interval: 3000,
                                pauseOnHover: true,
                                pagination: false,
                                breakpoints: {

                                    640: {
                                        perPage: 1, // small screens / mobile
                                    },
                                },
                            }}
                            className='max-w-[600px] mx-auto w-full'
                            aria-label="My React Splide Carousel">


                            {app?.embeds?.map((videoEmbed, index) => {
                                return (<SplideSlide key={index}><div dangerouslySetInnerHTML={{ __html: videoEmbed.embed ?? '' }} className="rounded-lg overflow-hidden min-w-[250px] h-[180px]   *:h-full *:w-full">

                                </div></SplideSlide>)
                            })}
                        </Splide> : ''}
                        </section> : ''}


                        {(app?.blocks_section && app?.blocks?.length > 0) ?<section className="flex flex-col gap-3 md:gap-7 mt-14">

                            {app?.blocks_section ? <h3 dangerouslySetInnerHTML={{ __html: app?.blocks_section ?? '' }} className='text-[22px] md:text-[32px] text-gray-900 font-bold mx-auto'></h3> : ''}
                            {app?.blocks?.length > 0 ? <div class="flex flex-col sm:grid  sm:grid-cols-2 gap-5  max-w-[600px] place-content-center mx-auto">
                                {app?.blocks?.map((block) => {
                                    return (
                                        <BlocksCard block={block} ></BlocksCard>
                                    )
                                })}

                            </div> : ''}
                        </section> : '' }

                        {(app?.services_section && app?.services?.length > 0) ?<section className="flex flex-col gap-3 md:gap-7 mt-14">
                            {app?.services_section ? <h3 dangerouslySetInnerHTML={{ __html: app?.services_section ?? '' }} className='text-[22px] md:text-[32px] text-gray-900 font-bold mx-auto'></h3> : ''}
                            {app?.services?.length > 0 ? <div class="flex flex-col sm:grid  sm:grid-cols-2 gap-5  max-w-[600px] place-content-center mx-auto">
                                {app?.services?.map((service) => {
                                    return (
                                        <ServicesCard service={service} ></ServicesCard>
                                    )
                                })}

                            </div> : ''}
                        </section> : ''}

                        {(app?.testimonials_section && app?.testimonials?.length > 0) ?<section className="flex flex-col gap-3 md:gap-7 mt-14">
                            {app?.testimonials_section ? <h3 dangerouslySetInnerHTML={{ __html: app?.testimonials_section ?? '' }} className='text-[22px] md:text-[32px] text-gray-900 font-bold mx-auto'></h3> : ''}
                            {app?.testimonials?.length > 0 && (
                                <Splide
                                    options={{
                                        perPage: 1,
                                        type: 'loop',
                                        autoplay: true,
                                        gap: '1.25rem',
                                        interval: 3000,
                                        pauseOnHover: true,
                                        pagination: false,
                                    }}
                                    className='max-w-[600px] mx-auto w-full'
                                    aria-label="Testimonials"
                                >
                                    {app.testimonials.map((testimonial) => (
                                        <SplideSlide key={testimonial?.id}>

                                            <div className="rounded-3xl p-10 bg-white shadow-lg max-w-md border border-soild border-gray-900 md:min-w-[448px] min-h-full mx-auto">
                                                <div className="flex gap-4 items-center">
                                                    <img
                                                        className="fit-cover w-[75px] aspect-square rounded-full border border-solid border-gray-900"
                                                        src={testimonial?.image}
                                                        alt=""
                                                    />
                                                    <div>
                                                        <h3
                                                            dangerouslySetInnerHTML={{ __html: testimonial?.name ?? '' }}
                                                            className="text-start text-lg font-medium text-gray-700"
                                                        ></h3>
                                                    </div>
                                                </div>
                                                <p
                                                    className="text-gray-700 mt-5 max-w-full"
                                                    dangerouslySetInnerHTML={{ __html: testimonial?.description ?? '' }}
                                                ></p>
                                            </div>

                                        </SplideSlide>
                                    ))}
                                </Splide>
                            )}
                        </section> : ''}



                        {app?.powered_by ? <section className="mt-12 text-[18px]">Powered By: <b>{app?.powered_by}</b></section> : ''}

                    </div>
                </div>
            </div>


        </div>
    );
}
