import React, { useEffect } from 'react'
import SideBar from '../../Components/SideBar'
import MobileBar from '../../Components/MobileBar';


import useUpdateUser from '../../hooks/useUpdateUser';
import useHandleToastMessages from '../../hooks/useHandleToastMessages';
import DashboardCard from '../../Components/Dashboard/DashboardCard';

import Table from '../../Components/TableLayout/Table';
import TableRow from '../../Components/TableLayout/TableRow';
import TableColumn from '../../Components/TableLayout/TableColumn';

import ProfileCard from '../../Components/ProfileCard';

import { useSelector } from 'react-redux';

export default function Index({ messages, online_users, number_of_published_contacts , number_of_contacts , recent_contacts}) {
    useHandleToastMessages(messages);

    const { loading, error, updateUser } = useUpdateUser();

    const roles = useSelector(state => state.user.roles)

    useEffect(() => {
        updateUser()
    }, [])
    
    return (
        <div className='md:flex bg-gray-200 min-h-[100dvh]'>
            <MobileBar />
            <SideBar />
            <section className='w-full md:p-10 p-4 flex max-md:flex-col gap-10'>
                <section className="w-full">
                    <h1 className="font-bold text-[26px] md:text-[32px] mb-5 text-gray-900">Dashboard</h1>
                    

                    {roles?.dashboard ? 
                    <div className='grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-10 mb-5' >
                        <DashboardCard title='Logged In Users'>{online_users ?? 0}</DashboardCard>
                        <DashboardCard title="Number Of Contacts">{number_of_contacts ?? 0}</DashboardCard>
                        <DashboardCard title="Published Contacts">{number_of_published_contacts ?? 0}</DashboardCard>
                    </div> : null }

                    {roles?.dashboard ? 
                    <section className='w-full overflow-auto'>
                        <h3 className='font-bold text-[20px] md:text-[24px] mb-5 text-gray-900'>Recently Added Contacts</h3>
                        {recent_contacts?.length >=1 ? <section>
                            <Table className={'min-w-[100%]'} headers={[ "Id","Code", "Published", "Name", "Phone", "Mobile", "Created By", "Updated By"]}>

                                {recent_contacts?.map(app => {
                                    return (
                                        <TableRow key={app?.id}>
                                            <TableColumn className={'font-semibold'}>{app?.id}</TableColumn>
                                            <TableColumn className={'font-semibold'}><a target='_blank' href={app?.code ? `/${app.code}` : ''}>{app?.code}</a></TableColumn>
                                            <TableColumn className='flex items-center justify-center'>
                                                {app?.published == true ? <div className='text-[11px] text-blue-500 font-bold'>Published</div> : <div className='text-[11px] text-red-500 font-bold'>Draft</div>}
                                            </TableColumn>
                                            <TableColumn>{app?.name ? app.name.replace(/<[^>]*>/g, "").slice(0, 20) : ''}</TableColumn>
                                            <TableColumn>{app?.number}</TableColumn>
                                            <TableColumn>{app?.mobile}</TableColumn>
                                            <TableColumn>{app?.created_by ?? ''}</TableColumn>
                                            <TableColumn>{app?.updated_by ?? ''}</TableColumn>
                                        </TableRow>
                                    )
                                })}

                            </Table>
                        </section> : ''} 
                    </section> : null }

                </section>

            </section>
        </div >
    );
}
