import React, { useState } from 'react'
import SideBar from '../../Components/SideBar'
import Table from '../../Components/TableLayout/Table';
import { Link, router } from "@inertiajs/react";

import { v4 as uuidv4 } from 'uuid';


//table layout
import TableHead from '../../Components/TableLayout/TableHead'
import TableRow from '../../Components/TableLayout/TableRow'
import TableColumn from '../../Components/TableLayout/TableColumn'
import SocialTypesForm from '../../Components/Forms/SocialTypesForm';
import MobileBar from '../../Components/MobileBar';

import { TablePagination } from '@mui/material';
import TableDropdownMenuItem from '../../Components/TableLayout/TableDropdownMenuItem';
import TableDropdownActions from '../../Components/TableLayout/TableDropdownActions';

import { useSelector } from 'react-redux';
import useHandleToastMessages from '../../hooks/useHandleToastMessages';
import HeaderForm from '../../Components/Forms/HeaderForm';
import HeaderMenusForm from '../../Components/Forms/HeaderMenusForm';
import { toast } from 'react-toastify';

export default function Index({ menus, messages,header,languages }) {

    useHandleToastMessages(messages);

    const [headerMenus, setHeaderMenus] = useState(header?.menus ?? []);
    const [selectedMenu,setSelectedMenu] =useState(null)

    const handleEditHeaderMenus = (data) => {
        setSelectedMenu(null);

            if(data?.id){
                //update existing header menu
                setHeaderMenus(headerMenus.map(menu => {
                    if (menu.id === data.id) {
                        return { ...menu, menu:data?.menu ?? null };
                    }
                    return menu;
                }));
                return;
            }

            //check if language is already found
            if(headerMenus.find(menu => menu.language.id === data.language.id )){
                toast.error('This language is already added to the header menu');
                return;
            }

            data.id = uuidv4();
            setHeaderMenus([...headerMenus, data]);
    }

    const handleDeleteHeaderMenus = (id) => {
        if(isFormDisabled()){
            return
        }
        //delete header menu
        setHeaderMenus(headerMenus.filter(menu => menu.id !== id));
        setSelectedMenu(null);

    }

    //state variables

    const roles = useSelector(state => state.user.roles);

    const handleEditHeader = (data) => {
        data.menus = headerMenus;
        router.post('/admin/header', data)
    }

    const isFormDisabled = () => {

        return roles?.headerE == false
    }

    return (
        <div className='md:flex bg-gray-200'>
            <MobileBar />
            <SideBar />
            <section className='w-full md:p-10 p-4 flex max-md:flex-col gap-10'>
                <section className="md:w-1/2">
                    <h1 class="font-bold text-[26px] md:text-[32px] mb-5 text-gray-900">Headers</h1>
                    <HeaderForm disabled={isFormDisabled()} DefaultData={header} menus={menus} onSubmit={handleEditHeader} />
                </section>
                <section className="md:w-1/2">
                    <h1 class="font-bold text-[26px] md:text-[32px] mb-5 text-gray-900">Header Menus</h1>
                    {headerMenus?.length > 0 ? 
                        <section className='w-full overflow-auto mt-10'>
                            <Table className={'w-full'} headers={[ "Header Menu", "Language","Actions"]}>

                                {headerMenus?.map(headerMenu => {
                                    return (
                                        <TableRow key={headerMenu?.id}>
                                            <TableColumn>{headerMenu?.menu?.title ?? ''}</TableColumn>
                                            <TableColumn><div className="w-5" dangerouslySetInnerHTML={{ __html: headerMenu?.language?.flag ?? null }}></div></TableColumn>

                                            <TableColumn>
                                                <section className='flex gap-5'>
                                                    <div  onClick={()=>{handleDeleteHeaderMenus(headerMenu?.id)}} className='text-[11px] text-red-500 font-bold cursor-pointer'>Delete</div>
                                                    <div  onClick={() => {if(isFormDisabled()){return}; setSelectedMenu(headerMenu) }} className='text-[11px] text-blue-500 font-bold cursor-pointer'>Edit</div>
                                                </section>
                                            </TableColumn>


                                        </TableRow>
                                    )
                                })}

                            </Table>
                        </section>
                    : ''}
                    <HeaderMenusForm disabled={isFormDisabled()} label={selectedMenu ? `Edit Header Menu (${selectedMenu?.language?.name})` : 'Add Header Menu'} onSubmit={handleEditHeaderMenus} languages={languages} menus={menus} DefaultData={selectedMenu} setState={setHeaderMenus} />
                </section>

                
            </section>
        </div >
    );
}
