import React, { useState } from 'react'
import SideBar from '../../Components/SideBar'
import MobileBar from '../../Components/MobileBar';

import useHandleToastMessages from '../../hooks/useHandleToastMessages';

import Table from '../../Components/TableLayout/Table';
import TableRow from '../../Components/TableLayout/TableRow';
import TableColumn from '../../Components/TableLayout/TableColumn';
import TablePagination from '@mui/material/TablePagination';

import { Link, router } from "@inertiajs/react";


import { useSelector } from 'react-redux';
import PagesForm from '../../Components/Forms/PagesForm';
import LanguagesForm from '../../Components/Forms/LanguagesForm';

export default function Index({ messages, recent_contacts, pages, languages }) {
    useHandleToastMessages(messages);

    const roles = useSelector(state => state.user.roles)

    //state variables
    const [currentPage, setCurrentPage] = useState(0)
    const [rowsPerPage, setRowsPerPage] = useState(25);

    const handleAddLanguage = (data) => {
        router.post('/admin/languages', data);
    }


    return (
        <div className='md:flex bg-gray-200 min-h-[100dvh]'>
            <MobileBar />
            <SideBar />
            <section className='w-full p-4 md:p-10 flex max-md:flex-col gap-10 bg-gray-200 '>
                {languages?.length > 0 ? <section className="md:w-2/3 max-w-[100%] h-fit">
                    <section className='w-full overflow-auto'> 
                        <Table className={'w-full'} headers={["Name", "Flag", "Locale", "Status", "Actions"]}>

                            {languages?.slice(currentPage * rowsPerPage, (currentPage + 1) * rowsPerPage)?.map(language => {
                                return (
                                    <TableRow key={language?.id}>
                                        <TableColumn>{language?.name ?? ''}</TableColumn>

                                        <TableColumn className={'font-semibold'}>{language?.flag ? <div className='max-h-5 max-w-5' dangerouslySetInnerHTML={{__html:language?.flag}}></div> : ''}</TableColumn>
                                        <TableColumn>{language?.locale ?? ''}</TableColumn>
                                        <TableColumn className='flex items-center justify-start'>
                                            {language?.status == true ? <div className='text-[11px] text-blue-500 font-bold'>Published</div> : <div className='text-[11px] text-red-500 font-bold'>Draft</div>}
                                        </TableColumn>
                                        <TableColumn>
                                            <section className='flex gap-5'>
                                                {roles?.languageD == true ? <div onClick={() => { router.delete(`/admin/languages/${language?.id}`) }} className='text-[11px] text-red-500 font-bold cursor-pointer'>Delete</div> : '' }
                                                {roles?.languageE ? <Link href={`/admin/languages/${language?.id}/edit`} className='text-[11px] text-blue-500 font-bold cursor-pointer'>Edit</Link> : '' }
                                            </section>
                                        </TableColumn>


                                    </TableRow>
                                )
                            })}

                        </Table>
                    </section>


                    <TablePagination
                        component="div"
                        className="flex items-start"
                        count={languages?.length ?? 0}
                        page={currentPage}
                        onPageChange={(event, newPage) => { setCurrentPage(newPage) }}
                        rowsPerPage={rowsPerPage}
                        onRowsPerPageChange={(event) => { setRowsPerPage(parseInt(event.target.value, 10)); setCurrentPage(0) }}
                    />
                </section> : ''}
                <section className="md:w-1/3">
                    <h1 class="font-bold text-[26px] md:text-[32px] mb-5 text-gray-900">Languages</h1>

                    <LanguagesForm onSubmit={handleAddLanguage} />

                </section>


            </section>
        </div >
    );
}
