import React, { useState } from 'react'
import SideBar from '../../Components/SideBar'
import MobileBar from '../../Components/MobileBar';

import useHandleToastMessages from '../../hooks/useHandleToastMessages';

import Table from '../../Components/TableLayout/Table';
import TableRow from '../../Components/TableLayout/TableRow';
import TableColumn from '../../Components/TableLayout/TableColumn';
import TablePagination from '@mui/material/TablePagination';

import { Link, router } from "@inertiajs/react";


import { useSelector } from 'react-redux';
import PagesForm from '../../Components/Forms/PagesForm';
import MenuForm from '../../Components/Forms/MenuForm';

export default function Index({ messages, menus }) {
    useHandleToastMessages(messages);

    const roles = useSelector(state => state.user.roles)

    //state variables
    const [currentPage, setCurrentPage] = useState(0)
    const [rowsPerPage, setRowsPerPage] = useState(25);

    const handleAddMenu = (data) => {
        router.post('/admin/menus', data);
    }


    return (
        <div className='md:flex bg-gray-200 min-h-[100dvh]'>
            <MobileBar />
            <SideBar />
            <section className='w-full p-4 md:p-10 flex max-md:flex-col gap-10 bg-gray-200 '>

                <section className="md:w-1/3">
                    <h1 class="font-bold text-[26px] md:text-[32px] mb-5 text-gray-900">Menu</h1>

                    <MenuForm onSubmit={handleAddMenu} />

                </section>
                {menus?.length > 0 ? <section className="md:w-fit max-w-[100%] h-fit">
                    <section className='w-fit overflow-auto'>
                        <Table className={'min-w-[300px]'} headers={["Title", "Actions"]}>

                            {menus?.slice(currentPage * rowsPerPage, (currentPage + 1) * rowsPerPage)?.map(menu => {
                                return (
                                    <TableRow key={menu?.id}>
                                        <TableColumn>{menu?.title ?? ''}</TableColumn>
                                        <TableColumn>
                                            <section className='flex gap-5'>
                                                {roles?.menuD == true ? <div onClick={() => { router.delete(`/admin/menus/${menu?.id}`) }} className='text-[11px] text-red-500 font-bold cursor-pointer'>Delete</div> : '' }
                                                {roles?.menuE == true ?<Link href={`/admin/menus/${menu?.id}/edit`} className='text-[11px] text-blue-500 font-bold cursor-pointer'>Edit</Link> : '' }
                                            </section>
                                        </TableColumn>


                                    </TableRow>
                                )
                            })}

                        </Table>
                    </section>


                    <TablePagination
                        component="div"
                        className="flex items-start"
                        count={menus?.length ?? 0}
                        page={currentPage}
                        onPageChange={(event, newPage) => { setCurrentPage(newPage) }}
                        rowsPerPage={rowsPerPage}
                        onRowsPerPageChange={(event) => { setRowsPerPage(parseInt(event.target.value, 10)); setCurrentPage(0) }}
                    />
                </section> : ''}

            </section>
        </div >
    );
}
