import React, { useState,useRef } from 'react'
import SideBar from '../../Components/SideBar'
import MobileBar from '../../Components/MobileBar';

import useHandleToastMessages from '../../hooks/useHandleToastMessages';

import Table from '../../Components/TableLayout/Table';
import TableRow from '../../Components/TableLayout/TableRow';
import TableColumn from '../../Components/TableLayout/TableColumn';
import TablePagination from '@mui/material/TablePagination';

import { Link, router } from "@inertiajs/react";


import { useSelector } from 'react-redux';
import PagesForm from '../../Components/Forms/PagesForm';
import MenuForm from '../../Components/Forms/MenuForm';
import { Accordion, AccordionDetails, AccordionSummary } from '@mui/material';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faArrowDown,faPlus } from '@fortawesome/free-solid-svg-icons';

import { v4 as uuidv4 } from 'uuid';

import Input from '../../Components/Input';
import Button from '../../Components/Button';
import MenuItem from '../../Components/Menu/MenuItemSortable';



import {
    arrayMove,
} from '@dnd-kit/sortable';
import SortableWidget from '../../Components/SortableWidget';
import MenuItemSortable from '../../Components/Menu/MenuItemSortable';


export default function Update({ messages,pages,menu }) {
    useHandleToastMessages(messages);

    const roles = useSelector(state => state.user.roles)

    //state variables
    const [parent, setParent] = useState(null);
    const [menuItems, setMenuItems] = useState(menu?.items ?? [])

    const [selectedMenuItem,setSelectedMenuItem] = useState(null)

    //ref variables
    const customLinkRef = useRef(null);
    const customLinkNameRef = useRef(null)
  

    const handleUpdateMenu = (data) => {
        router.put(`/admin/menus/${menu?.id ?? null}`, {
            items: menuItems,
            ...data
        });
    }

    const handleAddPageToMenu = (id) => {
        const page = pages?.filter(page => {
            return page?.id == id;
        });

        if (!page) {
            return;
        }

        setMenuItems((prevItems) => {
            const newItem = {
                id: uuidv4(),
                page_id: page[0]?.id ?? null,
                parent_id: (parent && parent !== 'Select An Option') ? parent : null,
                title: page[0]?.title ?? '',
                type: 'page',
                order: (() => {
                    const siblings = prevItems.filter(item => item.parent_id === ((parent && parent !== 'Select An Option') ? parent : null));
                    const maxOrder = siblings.length > 0 ? Math.max(...siblings.map(item => item.order)) : 0;
                    return maxOrder + 1;
                })(),
            };

            const updatedItems = [...prevItems, newItem];

            return updatedItems;
        });
    };

    const handleAddCustomLink = () => {
        setMenuItems((prevItems) => {
            const newItem = {
                id: uuidv4(),
                page_id: null,
                parent_id: (parent && parent !== 'Select An Option') ? parent : null,
                title: customLinkNameRef.current.value,
                link: customLinkRef.current.value,
                type: 'link',
                order: (() => {
                    const siblings = prevItems.filter(item => item.parent_id === ((parent && parent !== 'Select An Option') ? parent : null));
                    const maxOrder = siblings.length > 0 ? Math.max(...siblings.map(item => item.order)) : 0;
                    return maxOrder + 1;
                })(),
            };

            const updatedItems = [...prevItems, newItem];

            

            return updatedItems;
        });
    };

    const handleUpdateMenuItem = (data) => {
        setMenuItems(prevItems => {
            return prevItems.map(item => 
                item.id === data.id ? { ...item, [data.key]: data.value } : item
            );
        });
    };
    const handleDeleteMenuItem = (id) => {
        if (confirm("Do you want to delete menu item? This action cannot be undone.")) {
            setMenuItems(prevItems => {
                // Recursively remove the item and all its descendants
                const removeItemAndDescendants = (items, parentId) => {
                    return items.filter(item => {
                        if (item.id === parentId) return false;
                        const isDescendant = (currentItem) => {
                            if (currentItem.parent_id === parentId) {
                                return true;
                            }
                            const parent = items.find(i => i.id === currentItem.parent_id);
                            return parent ? isDescendant(parent) : false;
                        };
                        return !isDescendant(item);
                    });
                };

                return removeItemAndDescendants(prevItems, id);
            });
        }
    };



   

    const handleDragEnd = (event) => {
        const { active, over } = event;
        if (!over || active.id === over.id) return;

        const activeItem = menuItems.find(i => i.id === active.id);
        const overItem = menuItems.find(i => i.id === over.id);

        // Sort within the same parent
        const activeParentId = activeItem?.parent_id ?? null;
        const siblings = menuItems.filter(i => (i.parent_id ?? null) === activeParentId);

        const oldIndex = siblings.findIndex(i => i.id === active.id);
        const newIndex = siblings.findIndex(i => i.id === over.id);

        const reordered = arrayMove(siblings, oldIndex, newIndex);

        // Update the order attribute based on the new position
        reordered.forEach((item, index) => {
            item.order = index + 1; // Order starts from 1
        });

        // Build new menuItems array with reordered siblings
        const newMenuItems = [...menuItems.filter(i => (i.parent_id ?? null) !== activeParentId)];
        newMenuItems.push(...reordered);

        setMenuItems(newMenuItems);
    };

  const handleSetSelectedMenu = (id) => {
    const menuItem = menuItems?.find(item => item?.id == id);

    setSelectedMenuItem(menuItem);
  }




    const getFullTitle = (item, items) => {
        let title = item.title;
        let currentItem = item;

        while (currentItem.parent_id) {
            const parent = items.find(i => i.id === currentItem.parent_id);
            if (parent) {
                title = parent.title + ' -> ' + title;
                currentItem = parent;
            } else {
                break;
            }
        }

        return title;
    };

    return (
        <div className='md:flex bg-gray-200 min-h-[100dvh]'>
            <MobileBar />
            <SideBar />
            <section className='w-full p-4 md:p-10 flex max-md:flex-col gap-10 bg-gray-200 '>
                <section className="md:w-1/3">
                    <section className='bg-white rounded-[10px] p-5 '>
                     
                            <h1 className="font-bold text-[22px] mb-5 text-gray-900 text-center md:text-start">Widgets</h1>
     
                        {menuItems?.length > 0 ? (
                            <Input label="parent" type="Select" setState={setParent}>
                                <option value={null}>Select An Option</option>
                                {menuItems?.map(item => (
                                    
                                    <option key={item?.id} value={item?.id}>
                                        {getFullTitle(item, menuItems)}
                                    </option>
                                ))}
                            </Input>
                        ) : ''}
                        <Accordion slotProps={{ heading: { component: 'h4' } }}>
                            <AccordionSummary
                                expandIcon={<FontAwesomeIcon icon={faArrowDown} />}
                                aria-controls="panel1-content"
                                id="panel1-header"
                            >
                                Pages
                            </AccordionSummary>
                            <AccordionDetails>
                                {pages?.length > 0 ? pages?.map(page => (
                                    <section key={page?.id ?? 1} className="border border-solid rounded-[6px] px-3 py-2 mb-2 flex justify-between items-center">
                                        {page?.title}
                                        <FontAwesomeIcon
                                            className={'text-gray-900 cursor-pointer'}
                                            onClick={() => { handleAddPageToMenu( page?.id ?? 1 ) }}
                                            icon={faPlus}
                                        />
                                    </section>
                                )) : ''}
                            </AccordionDetails>
                        </Accordion>
                        <Accordion slotProps={{ heading: { component: 'h4' } }}>
                            <AccordionSummary
                                expandIcon={<FontAwesomeIcon icon={faArrowDown} />}
                                aria-controls="panel1-content"
                                id="panel1-header"
                            >
                                Custom Link
                            </AccordionSummary>
                            <AccordionDetails>
                                <Input label="Name" ref={customLinkNameRef}></Input>
                                <Input label="Link" ref={customLinkRef}></Input>
                                <Button onClick={handleAddCustomLink} className='mt-10 bg-gray-900 hover:bg-[#000000] mx-auto'>Add Link</Button>
                            </AccordionDetails>
                        </Accordion>

                    </section>
                    <MenuForm onSubmit={handleUpdateMenu} DefaultData={menu} className={'mt-10'} label={'Update Menu'}></MenuForm>
                </section>
                <section className="md:w-2/3">
                    <section className='bg-white rounded-[10px] p-5'>
                        <h1 className="font-bold text-[22px] mb-5 text-gray-900 text-center md:text-start">Menu Items</h1>
                        {menuItems?.length > 0 ? (
                            <SortableWidget items={menuItems?.filter(item => item.parent_id == null)} onDragEnd={handleDragEnd}>
                                {menuItems?.filter(item => item.parent_id == null).map(item => (
                                    <section className="mb-5" key={item?.id ?? uuidv4()}>
                                    <MenuItemSortable
                                        selectedMenuItem={selectedMenuItem}
                                        onSetSelectedMenuItem={handleSetSelectedMenu}
                                        items={menuItems}
                                        onDragEnd={handleDragEnd}
                                        onUpdateMenuItem={handleUpdateMenuItem}
                                        onDeleteMenuItem={handleDeleteMenuItem}
                                        
                                        item={item}
                                    />
                                    </section>
                                ))}
                            </SortableWidget>
                        ) : ''}
                    </section>
                </section>
            </section>
        </div>
    );
}
