import React, { useState } from 'react'
import SideBar from '../../Components/SideBar'
import MobileBar from '../../Components/MobileBar';

import useHandleToastMessages from '../../hooks/useHandleToastMessages';

import Table from '../../Components/TableLayout/Table';
import TableRow from '../../Components/TableLayout/TableRow';
import TableColumn from '../../Components/TableLayout/TableColumn';
import TablePagination from '@mui/material/TablePagination';

import { Link, router } from "@inertiajs/react";


import { useSelector } from 'react-redux';
import PagesForm from '../../Components/Forms/PagesForm';

export default function Index({ messages, pages, selected_page ,languages}) {
    useHandleToastMessages(messages);

    const roles = useSelector(state => state.user.roles)

    //state variables
    const [currentPage, setCurrentPage] = useState(0)
    const [rowsPerPage, setRowsPerPage] = useState(25);

    const handleEditPage = (data) => {
        router.put(`/admin/pages/${selected_page?.id ?? null}/quickUpdate`, data);
    }


    return (
        <div className='md:flex bg-gray-200 min-h-[100dvh]'>
            <MobileBar />
            <SideBar />
            <section className='w-full p-4 md:p-10 flex max-md:flex-col gap-10 bg-gray-200 '>
                {pages?.length > 0 ? <section className="md:w-2/3 max-w-[100%] h-fit">
                    <section className='w-full overflow-auto'>
                        <Table className={'w-full'} headers={["Title", "Language", "Status", "Slug", "Actions"]}>

                            {pages?.slice(currentPage * rowsPerPage, (currentPage + 1) * rowsPerPage)?.map(page => {
                                return (
                                    <TableRow key={page?.id}>
                                        <TableColumn>{page?.title ?? ''}</TableColumn>
                                        <TableColumn><div className="w-5" dangerouslySetInnerHTML={{ __html: page?.language?.flag ?? null }}></div></TableColumn>

                                        <TableColumn className='flex items-center justify-start'>
                                            {page?.published == true ? <div className='text-[11px] text-blue-500 font-bold'>Published</div> : <div className='text-[11px] text-red-500 font-bold'>Draft</div>}
                                        </TableColumn>
                                        <TableColumn className={'font-semibold'}><a target='_blank' href={page?.slug ? `/${page?.language?.locale ? `${page?.language?.locale}/` : '/'}${page.slug}` : '/'}>{page?.slug}</a></TableColumn>
                                        <TableColumn>
                                            <section className='flex gap-5'>
                                                {roles?.pageD == true ? <div onClick={() => { router.delete(`/admin/pages/${page?.id}`) }} className='text-[11px] text-red-500 font-bold cursor-pointer'>Delete</div> : ''}
                                                {roles?.pageE ? <div onClick={() => { router.get(`/admin/pages/${page?.id}/edit`) }} className='text-[11px] text-blue-500 font-bold cursor-pointer'>Quick Edit</div> : ''}
                                                {roles?.pageA ? <div onClick={() => { router.get(`/admin/pages/${page?.id}/duplicate`) }} className='text-[11px] text-blue-500 font-bold cursor-pointer'>Duplicate</div> : ''}
                                                {roles?.pageE ? <div onClick={() => { router.get(`/admin/page-builder?id=${page?.id}`) }} className='text-[11px] text-blue-500 font-bold cursor-pointer'>Edit With Editor</div> : ''}
                                            </section>
                                        </TableColumn>


                                    </TableRow>
                                )
                            })}

                        </Table>
                    </section>


                    <TablePagination
                        component="div"
                        className="flex items-start"
                        count={pages?.length ?? 0}
                        page={currentPage}
                        onPageChange={(event, newPage) => { setCurrentPage(newPage) }}
                        rowsPerPage={rowsPerPage}
                        onRowsPerPageChange={(event) => { setRowsPerPage(parseInt(event.target.value, 10)); setCurrentPage(0) }}
                    />
                </section> : ''}
                <section className="md:w-1/3">
                    <h1 class="font-bold text-[26px] md:text-[32px] mb-5 text-gray-900">Pages</h1>

                    <PagesForm languages={languages} DefaultData={selected_page} label={`Edit Page (/${selected_page?.slug??''})`} onSubmit={handleEditPage} />

                </section>


            </section>
        </div >
    );
}
