import React, { useState } from 'react'
import SideBar from '../../Components/SideBar'
import Table from '../../Components/TableLayout/Table';
import { router } from "@inertiajs/react";


//table layout
import TableHead from '../../Components/TableLayout/TableHead'
import TableRow from '../../Components/TableLayout/TableRow'
import TableColumn from '../../Components/TableLayout/TableColumn'
import SettingsForm from '../../Components/Forms/SettingsForm';
import MobileBar from '../../Components/MobileBar';

import { TablePagination } from '@mui/material';
import TableDropdownMenuItem from '../../Components/TableLayout/TableDropdownMenuItem';
import TableDropdownActions from '../../Components/TableLayout/TableDropdownActions';

import { useSelector } from 'react-redux';
import useHandleToastMessages from '../../hooks/useHandleToastMessages';

export default function Index({ settings, messages,references,languages }) {

  useHandleToastMessages(messages);

  const handleSubmit = (data) => {

    router.post('/admin/settings', data)
  }

  return (
    <div className='md:flex bg-gray-200'>
      <MobileBar />
      <SideBar />
      <section className='w-full md:p-10 p-4 flex max-md:flex-col gap-10'>
        <section className="md:w-1/2">
          <h1 class="font-bold text-[26px] md:text-[32px] mb-5 text-gray-900">Settings</h1>
          <h3 class="font-semibold text-[12px] md:text-[16px] max-md:text-justify text-gray-500">Settings in a system refer to the configurable options that allow users to customize how the system behaves or appears.</h3>

          <SettingsForm languages={languages} DefaultData={settings} onSubmit={handleSubmit} references={references} />

        </section>

      </section>
    </div >
  );
}
