import React, { useState } from 'react';
import { useDispatch } from 'react-redux';

import { updateUser as updateUserDetails } from '../store/slices/userSlice';

const useUpdateUser = () => {
    const dispatch = useDispatch();

    // state variables
    const [loading, setLoading] = useState(false);
    const [error, setError] = useState(null);

    const updateUser = () => {
        setLoading(true);
        fetch(`/admin/users/roles`, {
            method: 'get',
            headers: {
                'Content-Type': 'application/json',
                'Accept': 'application/json',
            },
        })
            .then(response => {
                if (response.status !== 200) {
                    throw new Error('Failed to fetch roles');
                }
                return response.json();
            })
            .then(data => {
                
                dispatch(updateUserDetails({roles:data.data.roles,email:data.data.email}));
            })
            .catch(error => {
                console.log(error);
                setError(error);
            })
            .finally(() => {
                setLoading(false);
            });
    };

    return { loading, error, updateUser };
};

export default useUpdateUser;