import React, { useState } from 'react'

import { toast } from 'react-toastify'

const useWriteNfc = () => {
    

    const [isWriting, setIsWriting] = useState(false);

    const writeNfc = async ({ type = 'url', message = '' }) => {
        if ("NDEFReader" in window) {
            const ndef = new NDEFReader();

            try {
                toast.info("Approach your NFC Card!");
                setIsWriting(true);

                await ndef.write({
                    records: [
                        {
                            recordType: type,
                            data: message,
                        },
                    ],
                });

                setIsWriting(false);
                toast.success("NFC Card is filled succesfully!");
            } catch (error) {
                setIsWriting(false);
                toast.error(error);
            }
        } else {
            toast.error("Web NFC is not supported.");
        }
    }

    return { writeNfc, isWriting }
}

export default useWriteNfc