
    <style>
        header {
            background:
                {{ $header->bg_color ?? '#000000' }}
            ;
            color:
                {{ $header->text_color ?? '#FFFFFF' }}
            ;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            position: sticky;
            z-index: 100;
            top: 0;
            width: 100%;
        }
    
        .navbar {
            width: 100%;
            max-width: 1200px;
            min-height: 75px;
            margin: auto;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 20px;
            gap: 2rem;
        }

        .navbar[data-rtl="1"] {
            direction: rtl;
        }

        .navbar[data-rtl="1"] .language-dropdown{
            margin-left:0px !important;
            margin-right: 0 !important
        }


        .language-dropdown svg,nav svg{
            width:20px
        }
    
        .logo img {
            max-height: 100px;
            max-width: 150px;
            object-fit: contain;
        }
        
        .mobile_logo {
            display: none;
        }
    
        .menu-toggle {
            display: none;
            font-size: 1.5rem;
            cursor: pointer;
            color:
                {{ $header->text_color ?? '#FFFFFF' }}
            ;
        }

        select{
            padding:0px;
            border:0px;
            max-width:75px
        }

        select option,select{
            font-weight:700
        }
    
        nav {

            margin: auto;
            height: 100%;
        }

            nav a{
        text-decoration: none;
        width:100%
    }

    ul,li{
        list-style: none;
        padding: 0px;
        margin: 0px;
    }

    .menu{
        display:flex
    }

    .bordered-section{
        display:flex;
        align-items: center;
        padding:8px 10px;
    }



    .submenu{
        display:none
    }

    li:hover > .submenu{
        display: block;
    }



    .menu li .bordered-section > a ,.submenu .bordered-section > i {
        color: {{ $header->text_color ?? '#FFFFFF' }};
    }

    .menu .bordered-section{
        background-color: {{ $header->bg_color ?? '#000000' }};
    }

    .submenu .bordered-section > a ,.submenu .bordered-section > i {
        color:{{ $header->sub_text_color ?? '#000000' }} !important;
    }

    .submenu .bordered-section{
        background-color: {{ $header->sub_bg_color ?? '#FFFFFF' }} !important;
        border: 1px solid {{$header->sub_text_color ?? '#000000'}};
    }

   

    @media(min-width:768px){
        .menu{
            position:relative
        }
        .submenu{
            position: absolute;
            min-width:160px
        }

            .bordered-section > a{
        flex:1
    }
    }

        /* Responsive Styles */
        @media (max-width: 768px) {

            .submenu .bordered-section > a ,.submenu .bordered-section > i {
        color:{{ $header->text_color ?? '#000000' }} !important;
    }

    .bordered-section {
        border:1px solid {{$header->text_color ?? '#000000' }} !important;
    }

    .submenu .bordered-section{
        background-color: {{ $header->bg_color ?? '#FFFFFF' }} !important
    }

    .menu-toggle {
        display: block;
    }

    

    .menu{
        display:block;
        width:100%
    }

    nav {
        position: fixed;
        top: 0px;
        left: 0;
        width: 100%;
        z-index:99999999;
        min-width:150px;
        background: {{ $header->bg_color ?? '#000000'}};
        color: {{ $header->text_color ?? '#FFFFFF' }};
        flex-direction: column;
        align-items: flex-start;
        padding: 0px;
        display: none;
    }



    nav.active {
        display: flex;
        padding:0px;
        width: fit-content
    }


    .logo {
        display: none;
    }

    .mobile_logo {
        display: block;
    }


}

    </style>

            @php
$currentLang = $languages->where('locale', $locale)->first()
            @endphp

    <header>
        @if ($canUpdate)
            <x-toolbar :page-id="$pageId"></x-toolbar>
        @endif
        <section data-rtl="{{ $currentLang->is_rtl == true  }}" class="navbar">
            <div >
                <a name="homepage" href="/">
                    <section class="logo">
                @if($header->logo)    
                    <img alt="logo" loading='lazy' src="{{ $header->logo }}"  />
                @else
                    Logo
                @endif
                </section>

<section class="mobile_logo">
                @if($header->mobile_logo)
                    <img alt="logo-mobile" style="max-width:120px" loading='lazy' src="{{ $header->mobile_logo }}" />
                @else
                    Mobile Logo
                @endif
                </section>
                </a>
            </div>
           
            
            <nav>
                
                <ul class="menu">
                    
    @foreach($header->menus[0]->menu->children as $child)
        @include('components.layout.header-menu', [
        'child' => $child,
        'language' => $currentLang,
        'depth' => 1
    ])
    @endforeach
</ul>


</nav>

<style>
.language-dropdown {
    position: relative;
    display: inline-block;
    margin-left:auto;
    width: 48px;
}

.language-dropdown-toggle {
    background: none;
    border: none;
    cursor: pointer;
    padding: 4px;
    width: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
}

.language-dropdown-menu {
    display: none;
    position: absolute;
    top: 100%;
    left: 0;
    background: white;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
    z-index: 100;
    border-radius: 6px;
    overflow: hidden;
}

.language-dropdown-menu.show {
    display: block;
}

.language-dropdown-menu button {
    background: none;
    border: none;
    padding: 6px 10px;
    cursor: pointer;
    width: 100%;
    display: flex;
    align-items: center;
    justify-content: start;
    transition: background 0.2s ease;
}

.language-dropdown-menu button:hover {
    background-color: #f0f0f0;
}
</style>

<div class="language-dropdown">
    <button name="language" class="language-dropdown-toggle" onclick="toggleLanguageDropdown()">
        {{-- Show current flag or globe --}}

        {!! $currentLang->flag !!}
    </button>
    <div id="languageDropdownMenu" class="language-dropdown-menu">
        @foreach ($languages as $language)
            <button onclick="window.location.href='/{{ $language->locale }}'">
                {!! $language->flag !!}
            </button>
        @endforeach
    </div>
</div>

<script>
function toggleLanguageDropdown() {
    const menu = document.getElementById('languageDropdownMenu');
    menu.classList.toggle('show');
}

// Close dropdown when clicking outside
document.addEventListener('click', function(event) {
    const dropdown = document.querySelector('.language-dropdown');
    if (!dropdown.contains(event.target)) {
        document.getElementById('languageDropdownMenu').classList.remove('show');
    }
});
</script> 
            <div class="menu-toggle" onclick="document.querySelector('nav').classList.toggle('active')">
                <i style="fill:white;width:20px" class="fas fa-bars"></i>
            </div>
        </section>
    </header>
