
    <style>
        header {
            background:
                <?php echo e($header->bg_color ?? '#000000'); ?>

            ;
            color:
                <?php echo e($header->text_color ?? '#FFFFFF'); ?>

            ;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            position: sticky;
            z-index: 100;
            top: 0;
            width: 100%;
        }
    
        .navbar {
            width: 100%;
            max-width: 1200px;
            min-height: 75px;
            margin: auto;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 20px;
            gap: 2rem;
        }

        .navbar[data-rtl="1"] {
            direction: rtl;
        }

        .navbar[data-rtl="1"] .language-dropdown{
            margin-left:0px !important;
            margin-right: 0 !important
        }


        .language-dropdown svg,nav svg{
            width:20px
        }
    
        .logo img {
            max-height: 100px;
            max-width: 150px;
            object-fit: contain;
        }
        
        .mobile_logo {
            display: none;
        }
    
        .menu-toggle {
            display: none;
            font-size: 1.5rem;
            cursor: pointer;
            color:
                <?php echo e($header->text_color ?? '#FFFFFF'); ?>

            ;
        }

        select{
            padding:0px;
            border:0px;
            max-width:75px
        }

        select option,select{
            font-weight:700
        }
    
        nav {

            margin: auto;
            height: 100%;
        }

            nav a{
        text-decoration: none;
        width:100%
    }

    ul,li{
        list-style: none;
        padding: 0px;
        margin: 0px;
    }

    .menu{
        display:flex
    }

    .bordered-section{
        display:flex;
        align-items: center;
        padding:8px 10px;
    }



    .submenu{
        display:none
    }

    li:hover > .submenu{
        display: block;
    }



    .menu li .bordered-section > a ,.submenu .bordered-section > i {
        color: <?php echo e($header->text_color ?? '#FFFFFF'); ?>;
    }

    .menu .bordered-section{
        background-color: <?php echo e($header->bg_color ?? '#000000'); ?>;
    }

    .submenu .bordered-section > a ,.submenu .bordered-section > i {
        color:<?php echo e($header->sub_text_color ?? '#000000'); ?> !important;
    }

    .submenu .bordered-section{
        background-color: <?php echo e($header->sub_bg_color ?? '#FFFFFF'); ?> !important;
        border: 1px solid <?php echo e($header->sub_text_color ?? '#000000'); ?>;
    }

   

    @media(min-width:768px){
        .menu{
            position:relative
        }
        .submenu{
            position: absolute;
            min-width:160px
        }

            .bordered-section > a{
        flex:1
    }
    }

        /* Responsive Styles */
        @media (max-width: 768px) {

            .submenu .bordered-section > a ,.submenu .bordered-section > i {
        color:<?php echo e($header->text_color ?? '#000000'); ?> !important;
    }

    .bordered-section {
        border:1px solid <?php echo e($header->text_color ?? '#000000'); ?> !important;
    }

    .submenu .bordered-section{
        background-color: <?php echo e($header->bg_color ?? '#FFFFFF'); ?> !important
    }

    .menu-toggle {
        display: block;
    }

    

    .menu{
        display:block;
        width:100%
    }

    nav {
        position: fixed;
        top: 0px;
        left: 0;
        width: 100%;
        z-index:99999999;
        min-width:150px;
        background: <?php echo e($header->bg_color ?? '#000000'); ?>;
        color: <?php echo e($header->text_color ?? '#FFFFFF'); ?>;
        flex-direction: column;
        align-items: flex-start;
        padding: 0px;
        display: none;
    }



    nav.active {
        display: flex;
        padding:0px;
        width: fit-content
    }


    .logo {
        display: none;
    }

    .mobile_logo {
        display: block;
    }


}

    </style>

            <?php
$currentLang = $languages->where('locale', $locale)->first()
            ?>

    <header>
        <?php if($canUpdate): ?>
            <?php if (isset($component)) { $__componentOriginald3004b9ddb69238e6c95f297222269db = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald3004b9ddb69238e6c95f297222269db = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.toolbar','data' => ['pageId' => $pageId]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('toolbar'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['page-id' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($pageId)]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald3004b9ddb69238e6c95f297222269db)): ?>
<?php $attributes = $__attributesOriginald3004b9ddb69238e6c95f297222269db; ?>
<?php unset($__attributesOriginald3004b9ddb69238e6c95f297222269db); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald3004b9ddb69238e6c95f297222269db)): ?>
<?php $component = $__componentOriginald3004b9ddb69238e6c95f297222269db; ?>
<?php unset($__componentOriginald3004b9ddb69238e6c95f297222269db); ?>
<?php endif; ?>
        <?php endif; ?>
        <section data-rtl="<?php echo e($currentLang->is_rtl == true); ?>" class="navbar">
            <div >
                <a name="homepage" href="/">
                    <section class="logo">
                <?php if($header->logo): ?>    
                    <img alt="logo" loading='lazy' src="<?php echo e($header->logo); ?>"  />
                <?php else: ?>
                    Logo
                <?php endif; ?>
                </section>

<section class="mobile_logo">
                <?php if($header->mobile_logo): ?>
                    <img alt="logo-mobile" style="max-width:120px" loading='lazy' src="<?php echo e($header->mobile_logo); ?>" />
                <?php else: ?>
                    Mobile Logo
                <?php endif; ?>
                </section>
                </a>
            </div>
           
            
            <nav>
                
                <ul class="menu">
                    
    <?php $__currentLoopData = $header->menus[0]->menu->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php echo $__env->make('components.layout.header-menu', [
        'child' => $child,
        'language' => $currentLang,
        'depth' => 1
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</ul>


</nav>

<style>
.language-dropdown {
    position: relative;
    display: inline-block;
    margin-left:auto;
    width: 48px;
}

.language-dropdown-toggle {
    background: none;
    border: none;
    cursor: pointer;
    padding: 4px;
    width: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
}

.language-dropdown-menu {
    display: none;
    position: absolute;
    top: 100%;
    left: 0;
    background: white;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
    z-index: 100;
    border-radius: 6px;
    overflow: hidden;
}

.language-dropdown-menu.show {
    display: block;
}

.language-dropdown-menu button {
    background: none;
    border: none;
    padding: 6px 10px;
    cursor: pointer;
    width: 100%;
    display: flex;
    align-items: center;
    justify-content: start;
    transition: background 0.2s ease;
}

.language-dropdown-menu button:hover {
    background-color: #f0f0f0;
}
</style>

<div class="language-dropdown">
    <button name="language" class="language-dropdown-toggle" onclick="toggleLanguageDropdown()">
        

        <?php echo $currentLang->flag; ?>

    </button>
    <div id="languageDropdownMenu" class="language-dropdown-menu">
        <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <button onclick="window.location.href='/<?php echo e($language->locale); ?>'">
                <?php echo $language->flag; ?>

            </button>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>

<script>
function toggleLanguageDropdown() {
    const menu = document.getElementById('languageDropdownMenu');
    menu.classList.toggle('show');
}

// Close dropdown when clicking outside
document.addEventListener('click', function(event) {
    const dropdown = document.querySelector('.language-dropdown');
    if (!dropdown.contains(event.target)) {
        document.getElementById('languageDropdownMenu').classList.remove('show');
    }
});
</script> 
            <div class="menu-toggle" onclick="document.querySelector('nav').classList.toggle('active')">
                <i style="fill:white;width:20px" class="fas fa-bars"></i>
            </div>
        </section>
    </header>
<?php /**PATH /home/twisqxks/index.twister-demo.com/resources/views/components/layout/header.blade.php ENDPATH**/ ?>