<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Demo Apps</title>
    <script src="js/bootstrap.min.css"></script>
    <link rel="icon" href="/assets/fav.ico">
    <link rel="stylesheet" href="css/bootstrap.min.css">
</head>

<body style="max-width:1280px;margin:auto;padding:24px">
    <?php
    $jsonData = file_get_contents('data.json');

    // Decode the JSON string into a PHP array
    $data = json_decode($jsonData, true);

    // Check if decoding was successful
    if (!$data || !isset($data['sections'])) {
        die('Invalid JSON data.');
    }


    // Loop through sections and display content
    foreach ($data['sections'] as $section) {
        ?>
        <section class=" mb-5">
            <h3 class="mb-3"><?= htmlspecialchars($section['title']) ?></h3>

            <section class="row g-5">

                <?php
                foreach ($section['content'] as $subsection) {
                    ?>

                    <section class="col-sm-6 col-md-4 col-lg-3">
                        <div class="card " style="height:100%">
                            <img style="height:165px;object-fit:cover" src="<?= htmlspecialchars($subsection['image'] ?? '', ENT_QUOTES, 'UTF-8') ?>"
                                class="card-img-top" alt="...">
                            <div class="card-body">
                                <h5 class="card-title"><?= htmlspecialchars($subsection['title'] ?? '') ?></h5>
                                <p style="min-height:48px" class="card-text"><?= htmlspecialchars($subsection['description'] ?? '') ?></p>
                                <div style="" class="d-flex justify-content-start align-items-end gap-2">
                                    <?php if (!empty($subsection['url'])): ?>
                                        <a target="_blank" href="<?= htmlspecialchars($subsection['url'], ENT_QUOTES, 'UTF-8') ?>"
                                            class="btn btn-primary">Local
                                            Url</a>
                                    <?php endif; ?>

                                    <?php if (!empty($subsection['live_url'])): ?>
                                        <a target="_blank"
                                            href="<?= htmlspecialchars($subsection['live_url'], ENT_QUOTES, 'UTF-8') ?>"
                                            class="btn btn-primary">Live Url</a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </section>
                    <?php
                }
                ?>
            </section>
        </section>
        <?php
    } ?>


</body>

</html>