<?php
add_action('init', function () {

    if (empty($_GET['include_uurl']) && is_main_query() && is_admin() && !empty($_GET['first_run']) && !wp_doing_ajax()) {

        /* Pages */
        $ppages = array(
            array('name' => 'Home', 'type' => 'page', 'file' => '/patterns/page-home-1.php', 'is_home' => true),
            array('name' => 'About Us', 'type' => 'page', 'file' => '/patterns/page-about-1.php'),
            array('name' => 'Contact Us', 'type' => 'page', 'file' => '/patterns/page-contact-1.php'),
            array('name' => 'starter footer 1', 'type' => 'wp_block', 'file' => '/patterns/footer-1.php'),
            array('name' => 'starter topbar 1', 'type' => 'wp_block', 'content' => '<!-- wp:paragraph --><p>UP TO 45% OFF BEST-SELLING FURNITURE. <a href="#">SHOP NOW</a></p><!-- /wp:paragraph -->'),
        );
        foreach ($ppages as $pge) {
            $ttitll = $pge["name"];
            $check_page_exist = get_page_by_title($ttitll, 'OBJECT', $pge["type"]);
            // Check if the page already exists
            if (empty($check_page_exist) && 1 == 1) {
                if (isset($pge["content"])) {
                    $svg_content = $pge["content"];
                } else {
                    $svg_content = "";
                    $remote_svg_file = wp_remote_get(get_stylesheet_directory_uri() . $pge["file"] . '?include_uurl=' . get_template_directory_uri());
                    $svg_content = wp_remote_retrieve_body($remote_svg_file);
                }
                $page_id = wp_insert_post(
                    array(
                        'comment_status' => 'close',
                        'ping_status'    => 'close',
                        'post_title'     => $ttitll,
                        'post_name'      => strtolower(str_replace(' ', '-', trim($ttitll))),
                        'post_status'    => 'publish', //C:UsersDeveloperDocumentsworkserverwwwashrafstarterwp-contentthemeshtml5blank-stablepatternspage-home-1.php
                        'post_content'   => $svg_content,
                        'post_type'      => $pge["type"]
                    )
                );
                if ($page_id && isset($pge["is_home"])) {
                    update_option('page_on_front', $page_id);
                    update_option('show_on_front', 'page');
                    update_post_meta($page_id, 'starter_body_style', 'starter_transparent-menu');
                }
            }
        }


        /* MENUS */
        $defaults_menues = array(
            'header-menu' => array("Home", "About Us", "Contact Us", "Shop", "Cart", "News"),
            'topbar-1-menu' => array("Language" => array("ENGLISH", "ARABIC")),
            'topbar-2-menu' => array("currency" => array("USD", "EUR")),
            'footer-1-menu' => array("Home", "About Us", "Contact Us"),
            'footer-2-menu' => array("Blog", "About Us", "Contact Us"),
            'bottombar-1-menu' => array("Privacy Policy", "Help", "FAQs"),

        );
        $menus = get_registered_nav_menus();
        foreach ($menus as $location => $description) {
            if (!has_nav_menu($location) && 1 == 1) {
                $menuname = ucwords(str_replace("-", " ", $location));
                // Does the menu exist already?
                $menu_exists = wp_get_nav_menu_object($menuname);

                // If it doesn't exist, let's create it.
                if (!$menu_exists && isset($defaults_menues[$location]) && 1 == 1) {
                    $menu_id = wp_create_nav_menu($menuname);

                    foreach ($defaults_menues[$location] as $k12 => $defaul) {

                        if (is_array($defaul)) {
                            //echo $k12.'.';
                            $strr = $k12;
                            $parent_item = wp_update_nav_menu_item($menu_id, 0, array(
                                'menu-item-title' =>  __($strr),
                                'menu-item-url' => home_url('/' . strtolower(str_replace(" ", "-", $strr))),
                                'menu-item-status' => 'publish'
                            ));
                            foreach ($defaul as $k123 => $defy) {
                                //echo $defy.'.';
                                $strr = $defy;
                                wp_update_nav_menu_item($menu_id, 0, array(
                                    'menu-item-title' =>  __($strr),
                                    'menu-item-url' => home_url('/' . strtolower(str_replace(" ", "-", $strr))),
                                    'menu-item-status' => 'publish',
                                    'menu-item-parent-id' => $parent_item
                                ));
                            }
                        } else {
                            //echo $defaul.'.';
                            $strr = $defaul;
                            wp_update_nav_menu_item($menu_id, 0, array(
                                'menu-item-title' =>  __($strr),
                                'menu-item-url' => home_url('/' . strtolower(str_replace(" ", "-", $strr))),
                                'menu-item-status' => 'publish'
                            ));
                        }
                    }



                    $locations = get_theme_mod('nav_menu_locations');
                    $locations[$location] = $menu_id;
                    set_theme_mod('nav_menu_locations', $locations);
                }
            }
        };

        update_option('starter_first_run', 'done');

        wp_safe_redirect('?page=starter_theme_options');
    }
});;
