let $q = jQuery;
$q(document).ready(function () {
	mapboxgl.accessToken = jQuery('#hdnMapAPI').val();
	map_x_0 = Number(jQuery('#map_x_0').val());
	map_y_0 = Number(jQuery('#map_y_0').val());
	_zoom = Number(jQuery('#zoom').val());
	mapboxgl.setRTLTextPlugin(
		'https://api.mapbox.com/mapbox-gl-js/plugins/mapbox-gl-rtl-text/v0.2.3/mapbox-gl-rtl-text.js'
	)
	var map = new mapboxgl.Map({
		container: 'map',
		style: 'mapbox://styles/mapbox/streets-v10',
		center: [map_x_0, map_y_0],
		zoom: _zoom,
	})

	var geojson = {
		type: 'FeatureCollection',
		features: [
			{
				type: 'Feature',
				geometry: {
					type: 'Point',
					coordinates: [map_x_0, map_y_0],
				},
			},
			/* {
				type: 'Feature',
				geometry: {
					type: 'Point',
					coordinates: [35.515159873345965, 33.89321079113722],
				},
			}, */
		],
	}
	document.querySelectorAll('[id^="map_x_"]').forEach(element => {
		if(element.id!='map_x_0'){

			geojson.features.push({
				type: 'Feature',
				geometry: {
					type: 'Point',
					coordinates: [element.value,document.querySelector('#'+element.id.replace('x','y')).value],
				},
			});
		}
	});
	geojson.features.forEach(function (marker) {
		var el = document.createElement('div');
		el.className = 'eh_marker';
		new mapboxgl.Marker(el).setLngLat(marker.geometry.coordinates).addTo(map)
	})

	map.scrollZoom.disable()
	map.addControl(new mapboxgl.NavigationControl())
})
