<?php 
add_filter( 'woocommerce_my_account_my_orders_actions', 'starter_order_again_action', 9999, 2 );
    
function starter_order_again_action( $actions, $order ) {
    //if ( $order->has_status( 'completed' ) ) {
        $actions['order-again'] = array(
            'url' => wp_nonce_url( add_query_arg( 'order_again', $order->get_id(), wc_get_cart_url() ), 'woocommerce-order_again' ),
            'name' => __( 'Order again', 'woocommerce' ),
        );
   // }
    return $actions;
}
///////////////////////
add_filter( 'woocommerce_valid_order_statuses_for_order_again', 'starter_order_again_more_statuses' );
 
function starter_order_again_more_statuses() {
   return array( 'completed', 'cancelled','processing' ); // basically add as many statuses as you wish to the array
}
///////////////////////////////////////////////////////
add_filter( 'woocommerce_min_password_strength', 'reduce_min_strength_password_requirement' );
function reduce_min_strength_password_requirement( $strength ) {
    // 3 => Strong (default) | 2 => Medium | 1 => Weak | 0 => Very Weak (anything).
    if(get_option( 'starter_weak_passwords','no')=='yes'){
        return 1;
    }
    return $strength; 
}
; ?>
